/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import jline.console.ConsoleReader;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.start.spi.KeywordExecutable;

public class CreateToken
implements KeywordExecutable {
    private ConsoleReader reader = null;

    private ConsoleReader getConsoleReader() throws IOException {
        if (this.reader == null) {
            this.reader = new ConsoleReader();
        }
        return this.reader;
    }

    public static void main(String[] args) {
        new CreateToken().execute(args);
    }

    public String keyword() {
        return "create-token";
    }

    public String description() {
        return "Creates authentication token";
    }

    public void execute(String[] args) {
        Opts opts = new Opts();
        opts.parseArgs("accumulo create-token", args, new Object[0]);
        ClientOpts.Password pass = opts.password;
        if (pass == null && opts.securePassword != null) {
            pass = opts.securePassword;
        }
        try {
            String principal = opts.principal;
            if (principal == null) {
                principal = this.getConsoleReader().readLine("Username (aka principal): ");
            }
            AuthenticationToken token = Class.forName(opts.tokenClassName).asSubclass(AuthenticationToken.class).newInstance();
            AuthenticationToken.Properties props = new AuthenticationToken.Properties();
            for (AuthenticationToken.TokenProperty tp : token.getProperties()) {
                String input = pass != null && tp.getKey().equals("password") ? pass.toString() : (tp.getMask() ? this.getConsoleReader().readLine(tp.getDescription() + ": ", Character.valueOf('*')) : this.getConsoleReader().readLine(tp.getDescription() + ": "));
                props.put(tp.getKey(), input);
                token.init(props);
            }
            System.out.println("auth.type = " + opts.tokenClassName);
            System.out.println("auth.principal = " + principal);
            System.out.println("auth.token = " + ClientProperty.encodeToken(token));
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"-u", "--user"}, description="Connection user")
        public String principal = null;
        @Parameter(names={"-p"}, converter=ClientOpts.PasswordConverter.class, description="Connection password")
        public ClientOpts.Password password = null;
        @Parameter(names={"--password"}, converter=ClientOpts.PasswordConverter.class, description="Enter the connection password", password=true)
        public ClientOpts.Password securePassword = null;
        @Parameter(names={"-tc", "--tokenClass"}, description="The class of the authentication token")
        public String tokenClassName = PasswordToken.class.getName();

        Opts() {
        }
    }
}

