/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class CompletableFutureUtil {
    public static <T> CompletableFuture<T> merge(List<CompletableFuture<T>> futures, BiFunction<T, T, T> mergeFunc, Supplier<T> nothing) {
        if (futures.size() == 0) {
            return CompletableFuture.completedFuture(nothing.get());
        }
        while (futures.size() > 1) {
            ArrayList<CompletableFuture<T>> mergedFutures = new ArrayList<CompletableFuture<T>>(futures.size() / 2);
            for (int i = 0; i < futures.size(); i += 2) {
                if (i + 1 == futures.size()) {
                    mergedFutures.add(futures.get(i));
                    continue;
                }
                mergedFutures.add((CompletableFuture<T>)futures.get(i).thenCombine(futures.get(i + 1), mergeFunc));
            }
            futures = mergedFutures;
        }
        return futures.get(0);
    }
}

