/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.TableId;
import org.apache.hadoop.io.Text;

public class ByteBufferUtil {
    public static byte[] toBytes(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (buffer.hasArray()) {
            return Arrays.copyOfRange(buffer.array(), buffer.position() + buffer.arrayOffset(), buffer.limit() + buffer.arrayOffset());
        }
        byte[] data = new byte[buffer.remaining()];
        buffer.duplicate().get(data);
        return data;
    }

    public static List<ByteBuffer> toByteBuffers(Collection<byte[]> bytesList) {
        if (bytesList == null) {
            return null;
        }
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        for (byte[] bytes : bytesList) {
            result.add(ByteBuffer.wrap(bytes));
        }
        return result;
    }

    public static List<byte[]> toBytesList(Collection<ByteBuffer> bytesList) {
        if (bytesList == null) {
            return null;
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>(bytesList.size());
        for (ByteBuffer bytes : bytesList) {
            result.add(ByteBufferUtil.toBytes(bytes));
        }
        return result;
    }

    public static Text toText(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        if (byteBuffer.hasArray()) {
            Text result = new Text();
            result.set(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            return result;
        }
        return new Text(ByteBufferUtil.toBytes(byteBuffer));
    }

    public static String toString(ByteBuffer bytes) {
        if (bytes.hasArray()) {
            return new String(bytes.array(), bytes.arrayOffset() + bytes.position(), bytes.remaining(), StandardCharsets.UTF_8);
        }
        return new String(ByteBufferUtil.toBytes(bytes), StandardCharsets.UTF_8);
    }

    public static TableId toTableId(ByteBuffer bytes) {
        return TableId.of(ByteBufferUtil.toString(bytes));
    }

    public static ByteBuffer toByteBuffers(ByteSequence bs) {
        if (bs == null) {
            return null;
        }
        if (bs.isBackedByArray()) {
            return ByteBuffer.wrap(bs.getBackingArray(), bs.offset(), bs.length());
        }
        return ByteBuffer.wrap(bs.toArray());
    }

    public static void write(DataOutput out, ByteBuffer buffer) throws IOException {
        if (buffer.hasArray()) {
            out.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        } else {
            out.write(ByteBufferUtil.toBytes(buffer));
        }
    }

    public static ByteArrayInputStream toByteArrayInputStream(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            return new ByteArrayInputStream(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        }
        return new ByteArrayInputStream(ByteBufferUtil.toBytes(buffer));
    }
}

