/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.trace;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.htrace.HTraceConfiguration;
import org.apache.htrace.NullScope;
import org.apache.htrace.Span;
import org.apache.htrace.SpanReceiver;
import org.apache.htrace.SpanReceiverBuilder;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceInfo;
import org.apache.htrace.TraceScope;
import org.apache.htrace.impl.CountSampler;
import org.apache.htrace.impl.ProbabilitySampler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceUtil {
    private static final Logger log = LoggerFactory.getLogger(TraceUtil.class);
    public static final String TRACE_HOST_PROPERTY = "trace.host";
    public static final String TRACE_SERVICE_PROPERTY = "trace.service";
    public static final String TRACER_ZK_HOST = "tracer.zookeeper.host";
    public static final String TRACER_ZK_TIMEOUT = "tracer.zookeeper.timeout";
    public static final String TRACER_ZK_PATH = "tracer.zookeeper.path";
    private static final HashSet<SpanReceiver> receivers = new HashSet();
    private static final TInfo DONT_TRACE = new TInfo(0L, 0L);

    public static void enableClientTraces(String hostname, String service, Properties properties) {
        TraceUtil.enableTracing(hostname, service, ClientProperty.TRACE_SPAN_RECEIVERS.getValue(properties), ClientProperty.INSTANCE_ZOOKEEPERS.getValue(properties), ConfigurationTypeHelper.getTimeInMillis(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT.getValue(properties)), ClientProperty.TRACE_ZOOKEEPER_PATH.getValue(properties), ClientProperty.toMap(ClientProperty.getPrefix(properties, "trace.span.receiver")));
    }

    public static void enableServerTraces(String hostname, String service, AccumuloConfiguration conf) {
        TraceUtil.enableTracing(hostname, service, conf.get(Property.TRACE_SPAN_RECEIVERS), conf.get(Property.INSTANCE_ZK_HOST), conf.getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT), conf.get(Property.TRACE_ZK_PATH), conf.getAllPropertiesWithPrefix(Property.TRACE_SPAN_RECEIVER_PREFIX));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enableTracing(String hostname, String service, String spanReceivers, String zookeepers, long timeout, String zkPath, Map<String, String> spanReceiverProps) {
        Map htraceConfigProps = spanReceiverProps.entrySet().stream().collect(Collectors.toMap(k -> String.valueOf(k).substring(Property.TRACE_SPAN_RECEIVER_PREFIX.getKey().length()), v -> String.valueOf(v), (a, b) -> {
            throw new AssertionError((Object)"duplicate can't happen");
        }, HashMap::new));
        htraceConfigProps.put(TRACER_ZK_HOST, zookeepers);
        htraceConfigProps.put(TRACER_ZK_TIMEOUT, Long.toString(timeout));
        htraceConfigProps.put(TRACER_ZK_PATH, zkPath);
        if (hostname != null) {
            htraceConfigProps.put(TRACE_HOST_PROPERTY, hostname);
        }
        if (service != null) {
            htraceConfigProps.put(TRACE_SERVICE_PROPERTY, service);
        }
        ShutdownHookManager.get().addShutdownHook(() -> TraceUtil.disable(), 0);
        HashSet<SpanReceiver> hashSet = receivers;
        synchronized (hashSet) {
            if (!receivers.isEmpty()) {
                log.info("Already loaded span receivers, enable tracing does not need to be called again");
                return;
            }
            if (spanReceivers == null) {
                return;
            }
            Stream.of(spanReceivers.split(",")).map(String::trim).filter(s -> !s.isEmpty()).forEach(className -> {
                HTraceConfiguration htraceConf = HTraceConfiguration.fromMap((Map)htraceConfigProps);
                SpanReceiverBuilder builder = new SpanReceiverBuilder(htraceConf);
                SpanReceiver rcvr = builder.spanReceiverClass(className.trim()).build();
                if (rcvr == null) {
                    log.warn("Failed to load SpanReceiver {}", className);
                } else {
                    receivers.add(rcvr);
                    log.debug("SpanReceiver {} was loaded successfully.", className);
                }
            });
            for (SpanReceiver rcvr : receivers) {
                Trace.addReceiver((SpanReceiver)rcvr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disable() {
        HashSet<SpanReceiver> hashSet = receivers;
        synchronized (hashSet) {
            receivers.forEach(rcvr -> {
                try {
                    rcvr.close();
                }
                catch (IOException e) {
                    log.warn("Unable to close SpanReceiver correctly: {}", (Object)e.getMessage(), (Object)e);
                }
            });
            receivers.clear();
        }
    }

    public static TraceScope trace(TInfo info, String description) {
        return info.traceId == 0L ? NullScope.INSTANCE : Trace.startSpan((String)description, (TraceInfo)new TraceInfo(info.traceId, info.parentId));
    }

    public static TInfo traceInfo() {
        Span span = Trace.currentSpan();
        if (span != null) {
            return new TInfo(span.getTraceId(), span.getSpanId());
        }
        return DONT_TRACE;
    }

    public static CountSampler countSampler(long frequency) {
        return new CountSampler(HTraceConfiguration.fromMap(Collections.singletonMap("sampler.frequency", Long.toString(frequency))));
    }

    public static ProbabilitySampler probabilitySampler(double fraction) {
        return new ProbabilitySampler(HTraceConfiguration.fromMap(Collections.singletonMap("sampler.fraction", Double.toString(fraction))));
    }

    public static <T> T wrapClient(T instance) {
        InvocationHandler handler = (obj, method, args) -> {
            Object object;
            block10: {
                if (args == null || args.length < 1 || args[0] != null) {
                    return method.invoke(instance, args);
                }
                if (TInfo.class.isAssignableFrom(method.getParameterTypes()[0])) {
                    args[0] = TraceUtil.traceInfo();
                }
                TraceScope span = Trace.startSpan((String)("client:" + method.getName()));
                try {
                    object = method.invoke(instance, args);
                    if (span == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (span != null) {
                            try {
                                span.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InvocationTargetException ex) {
                        throw ex.getCause();
                    }
                }
                span.close();
            }
            return object;
        };
        return TraceUtil.wrapRpc(handler, instance);
    }

    public static <T> T wrapService(T instance) {
        InvocationHandler handler = (obj, method, args) -> {
            Object object;
            block9: {
                if (args == null || args.length < 1 || args[0] == null || !(args[0] instanceof TInfo)) {
                    return method.invoke(instance, args);
                }
                TraceScope span = TraceUtil.trace((TInfo)args[0], method.getName());
                try {
                    object = method.invoke(instance, args);
                    if (span == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (span != null) {
                            try {
                                span.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InvocationTargetException ex) {
                        throw ex.getCause();
                    }
                }
                span.close();
            }
            return object;
        };
        return TraceUtil.wrapRpc(handler, instance);
    }

    private static <T> T wrapRpc(InvocationHandler handler, T instance) {
        Object proxiedInstance = Proxy.newProxyInstance(instance.getClass().getClassLoader(), instance.getClass().getInterfaces(), handler);
        return (T)proxiedInstance;
    }
}

