/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.summary;

import java.io.IOException;
import org.apache.accumulo.core.client.summary.Summarizer;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;

public class SummarizerFactory {
    private ClassLoader classloader;
    private String context;

    public SummarizerFactory() {
        this.classloader = SummarizerFactory.class.getClassLoader();
    }

    public SummarizerFactory(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public SummarizerFactory(AccumuloConfiguration tableConfig) {
        this.context = tableConfig.get(Property.TABLE_CLASSPATH);
    }

    private Summarizer newSummarizer(String classname) throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException {
        if (this.classloader != null) {
            return this.classloader.loadClass(classname).asSubclass(Summarizer.class).newInstance();
        }
        if (this.context != null && !this.context.equals("")) {
            return (Summarizer)AccumuloVFSClassLoader.getContextManager().loadClass(this.context, classname, Summarizer.class).newInstance();
        }
        return (Summarizer)AccumuloVFSClassLoader.loadClass((String)classname, Summarizer.class).newInstance();
    }

    public Summarizer getSummarizer(SummarizerConfiguration conf) {
        try {
            return this.newSummarizer(conf.getClassName());
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

