/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.summary;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ServerClient;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TRowRange;
import org.apache.accumulo.core.dataImpl.thrift.TSummaries;
import org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.spi.cache.BlockCache;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.summary.SummarizerConfigurationUtil;
import org.apache.accumulo.core.summary.SummarizerFactory;
import org.apache.accumulo.core.summary.SummaryCollection;
import org.apache.accumulo.core.summary.SummaryReader;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.CancelFlagFuture;
import org.apache.accumulo.core.util.CompletableFutureUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gatherer {
    private static final Logger log = LoggerFactory.getLogger(Gatherer.class);
    private ClientContext ctx;
    private TableId tableId;
    private SummarizerFactory factory;
    private Text startRow = null;
    private Text endRow = null;
    private Range clipRange;
    private Predicate<SummarizerConfiguration> summarySelector;
    private CryptoService cryptoService;
    private TSummaryRequest request;
    private String summarizerPattern;
    private Set<SummarizerConfiguration> summaries;

    public Gatherer(ClientContext context, TSummaryRequest request, AccumuloConfiguration tableConfig, CryptoService cryptoService) {
        this.ctx = context;
        this.tableId = TableId.of(request.tableId);
        this.startRow = ByteBufferUtil.toText(request.bounds.startRow);
        this.endRow = ByteBufferUtil.toText(request.bounds.endRow);
        this.clipRange = new Range(this.startRow, false, this.endRow, true);
        this.summaries = request.getSummarizers().stream().map(SummarizerConfigurationUtil::fromThrift).collect(Collectors.toSet());
        this.request = request;
        this.cryptoService = cryptoService;
        this.summarizerPattern = request.getSummarizerPattern();
        if (this.summarizerPattern != null) {
            Pattern pattern = Pattern.compile(this.summarizerPattern);
            this.summarySelector = conf -> pattern.matcher(conf.getClassName() + " " + new TreeMap<String, String>(conf.getOptions())).matches();
            if (!this.summaries.isEmpty()) {
                this.summarySelector = this.summarySelector.or(conf -> this.summaries.contains(conf));
            }
        } else {
            this.summarySelector = !this.summaries.isEmpty() ? conf -> this.summaries.contains(conf) : conf -> true;
        }
        this.factory = new SummarizerFactory(tableConfig);
    }

    private TSummaryRequest getRequest() {
        return this.request;
    }

    private Map<String, Map<String, List<TRowRange>>> getFilesGroupedByLocation(Predicate<String> fileSelector) {
        TabletsMetadata tmi = TabletsMetadata.builder().forTable(this.tableId).overlapping(this.startRow, this.endRow).fetchFiles().fetchLocation().fetchLast().fetchPrev().build(this.ctx);
        HashMap<String, List> files = new HashMap<String, List>();
        for (TabletMetadata tm2 : tmi) {
            for (String string : tm2.getFiles()) {
                if (!fileSelector.test(string)) continue;
                files.computeIfAbsent(string, s -> new ArrayList()).add(tm2);
            }
        }
        HashMap<String, Map<String, List<TRowRange>>> locations = new HashMap<String, Map<String, List<TRowRange>>>();
        List<String> tservers = null;
        for (Map.Entry entry : files.entrySet()) {
            String location = ((List)entry.getValue()).stream().filter(tm -> tm.getLocation() != null).map(tm -> tm.getLocation().getHostAndPort().toString()).min(String::compareTo).orElse(((List)entry.getValue()).stream().filter(tm -> tm.getLast() != null).map(tm -> tm.getLast().getHostAndPort().toString()).min(String::compareTo).orElse(null));
            if (location == null) {
                if (tservers == null) {
                    tservers = this.ctx.instanceOperations().getTabletServers();
                    Collections.sort(tservers);
                }
                int idx = Math.abs(Hashing.murmur3_32().hashString((CharSequence)entry.getKey(), StandardCharsets.UTF_8).asInt()) % tservers.size();
                location = tservers.get(idx);
            }
            List<Range> merged = Range.mergeOverlapping(Lists.transform((List)((List)entry.getValue()), tm -> tm.getExtent().toDataRange()));
            List ranges = merged.stream().map(r -> this.toClippedExtent((Range)r).toThrift()).collect(Collectors.toList());
            locations.computeIfAbsent(location, s -> new HashMap()).put((String)entry.getKey(), ranges);
        }
        return locations;
    }

    private <K, V> Iterable<Map<K, V>> partition(Map<K, V> map, final int max) {
        if (map.size() < max) {
            return Collections.singletonList(map);
        }
        return () -> {
            final Iterator esi = map.entrySet().iterator();
            return new Iterator<Map<K, V>>(){

                @Override
                public boolean hasNext() {
                    return esi.hasNext();
                }

                @Override
                public Map<K, V> next() {
                    HashMap workingMap = new HashMap(max);
                    while (esi.hasNext() && workingMap.size() < max) {
                        Map.Entry entry = (Map.Entry)esi.next();
                        workingMap.put(entry.getKey(), entry.getValue());
                    }
                    return workingMap;
                }
            };
        };
    }

    public Future<SummaryCollection> processPartition(ExecutorService execSrv, int modulus, int remainder) {
        PartitionFuture future = new PartitionFuture(TraceUtil.traceInfo(), execSrv, modulus, remainder);
        future.initiateProcessing();
        return future;
    }

    public Future<SummaryCollection> processFiles(FileSystemResolver volMgr, Map<String, List<TRowRange>> files, BlockCache summaryCache, BlockCache indexCache, Cache<String, Long> fileLenCache, ExecutorService srp) {
        ArrayList futures = new ArrayList();
        for (Map.Entry<String, List<TRowRange>> entry : files.entrySet()) {
            futures.add(CompletableFuture.supplyAsync(() -> {
                List rrl = Lists.transform((List)((List)entry.getValue()), RowRange::new);
                return this.getSummaries(volMgr, (String)entry.getKey(), rrl, summaryCache, indexCache, fileLenCache);
            }, srp));
        }
        return CompletableFutureUtil.merge(futures, (sc1, sc2) -> SummaryCollection.merge(sc1, sc2, this.factory), SummaryCollection::new);
    }

    private int countFiles() {
        return TabletsMetadata.builder().forTable(this.tableId).overlapping(this.startRow, this.endRow).fetchFiles().fetchPrev().build(this.ctx).stream().mapToInt(tm -> tm.getFiles().size()).sum();
    }

    public Future<SummaryCollection> gather(ExecutorService es) {
        int numFiles = this.countFiles();
        log.debug("Gathering summaries from {} files", (Object)numFiles);
        if (numFiles == 0) {
            return CompletableFuture.completedFuture(new SummaryCollection());
        }
        int numRequest = Math.max(numFiles / 100000, 1);
        ArrayList futures = new ArrayList();
        AtomicBoolean cancelFlag = new AtomicBoolean(false);
        TInfo tinfo = TraceUtil.traceInfo();
        for (int i = 0; i < numRequest; ++i) {
            futures.add(CompletableFuture.supplyAsync(new GatherRequest(tinfo, i, numRequest, cancelFlag), es));
        }
        CompletableFuture<SummaryCollection> future = CompletableFutureUtil.merge(futures, (sc1, sc2) -> SummaryCollection.merge(sc1, sc2, this.factory), SummaryCollection::new);
        return new CancelFlagFuture<SummaryCollection>(future, cancelFlag);
    }

    private static Text removeTrailingZeroFromRow(Key k) {
        if (k != null) {
            Text t = new Text();
            ByteSequence row = k.getRowData();
            Preconditions.checkArgument((row.length() >= 1 && row.byteAt(row.length() - 1) == 0 ? 1 : 0) != 0);
            t.set(row.getBackingArray(), row.offset(), row.length() - 1);
            return t;
        }
        return null;
    }

    private RowRange toClippedExtent(Range r) {
        r = this.clipRange.clip(r);
        Text startRow = Gatherer.removeTrailingZeroFromRow(r.getStartKey());
        Text endRow = Gatherer.removeTrailingZeroFromRow(r.getEndKey());
        return new RowRange(startRow, endRow);
    }

    private SummaryCollection getSummaries(FileSystemResolver volMgr, String file, List<RowRange> ranges, BlockCache summaryCache, BlockCache indexCache, Cache<String, Long> fileLenCache) {
        Path path = new Path(file);
        Configuration conf = this.ctx.getHadoopConf();
        return SummaryReader.load(volMgr.get(path), conf, this.factory, path, this.summarySelector, summaryCache, indexCache, fileLenCache, this.cryptoService).getSummaries(ranges);
    }

    static /* synthetic */ Iterable access$100(Gatherer x0, Map x1, int x2) {
        return x0.partition(x1, x2);
    }

    public static class RowRange {
        private Text startRow;
        private Text endRow;

        public RowRange(KeyExtent ke) {
            this.startRow = ke.getPrevEndRow();
            this.endRow = ke.getEndRow();
        }

        public RowRange(TRowRange trr) {
            this.startRow = ByteBufferUtil.toText(trr.startRow);
            this.endRow = ByteBufferUtil.toText(trr.endRow);
        }

        public RowRange(Text startRow, Text endRow) {
            this.startRow = startRow;
            this.endRow = endRow;
        }

        public Range toRange() {
            return new Range(this.startRow, false, this.endRow, true);
        }

        public TRowRange toThrift() {
            return new TRowRange(TextUtil.getByteBuffer(this.startRow), TextUtil.getByteBuffer(this.endRow));
        }

        public Text getStartRow() {
            return this.startRow;
        }

        public Text getEndRow() {
            return this.endRow;
        }

        public String toString() {
            return this.startRow + " " + this.endRow;
        }
    }

    private class GatherRequest
    implements Supplier<SummaryCollection> {
        private int remainder;
        private int modulus;
        private TInfo tinfo;
        private AtomicBoolean cancelFlag;

        GatherRequest(TInfo tinfo, int remainder, int modulus, AtomicBoolean cancelFlag) {
            this.remainder = remainder;
            this.modulus = modulus;
            this.tinfo = tinfo;
            this.cancelFlag = cancelFlag;
        }

        @Override
        public SummaryCollection get() {
            TSummaries tSums;
            TSummaryRequest req = Gatherer.this.getRequest();
            try {
                tSums = ServerClient.execute(Gatherer.this.ctx, new TabletClientService.Client.Factory(), client -> {
                    TSummaries tsr = client.startGetSummariesForPartition(this.tinfo, Gatherer.this.ctx.rpcCreds(), req, this.modulus, this.remainder);
                    while (!tsr.finished && !this.cancelFlag.get()) {
                        tsr = client.contiuneGetSummaries(this.tinfo, tsr.sessionId);
                    }
                    return tsr;
                });
            }
            catch (AccumuloException | AccumuloSecurityException e) {
                throw new RuntimeException(e);
            }
            if (this.cancelFlag.get()) {
                throw new RuntimeException("Operation canceled");
            }
            return new SummaryCollection(tSums);
        }
    }

    public static interface FileSystemResolver {
        public FileSystem get(Path var1);
    }

    private class PartitionFuture
    implements Future<SummaryCollection> {
        private CompletableFuture<ProcessedFiles> future;
        private int modulus;
        private int remainder;
        private ExecutorService execSrv;
        private TInfo tinfo;
        private AtomicBoolean cancelFlag = new AtomicBoolean(false);

        PartitionFuture(TInfo tinfo, ExecutorService execSrv, int modulus, int remainder) {
            this.tinfo = tinfo;
            this.execSrv = execSrv;
            this.modulus = modulus;
            this.remainder = remainder;
        }

        private synchronized void initiateProcessing(ProcessedFiles previousWork) {
            try {
                Predicate<String> fileSelector = file -> Math.abs(Hashing.murmur3_32().hashString((CharSequence)file, StandardCharsets.UTF_8).asInt()) % this.modulus == this.remainder;
                if (previousWork != null) {
                    fileSelector = fileSelector.and(previousWork.failedFiles::contains);
                }
                Map filesGBL = Gatherer.this.getFilesGroupedByLocation(fileSelector);
                ArrayList futures = new ArrayList();
                if (previousWork != null) {
                    futures.add(CompletableFuture.completedFuture(new ProcessedFiles(previousWork.summaries, Gatherer.this.factory)));
                }
                for (Map.Entry entry : filesGBL.entrySet()) {
                    HostAndPort location = HostAndPort.fromString((String)entry.getKey());
                    Map allFiles = (Map)entry.getValue();
                    futures.add(CompletableFuture.supplyAsync(new FilesProcessor(this.tinfo, location, allFiles, this.cancelFlag), this.execSrv));
                }
                this.future = CompletableFutureUtil.merge(futures, (pf1, pf2) -> ProcessedFiles.merge(pf1, pf2, Gatherer.this.factory), ProcessedFiles::new);
                this.future.thenRun(this::updateFuture);
            }
            catch (Exception e) {
                this.future = CompletableFuture.completedFuture(new ProcessedFiles());
                this.future.obtrudeException(e);
            }
        }

        private ProcessedFiles _get() {
            try {
                return this.future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        private synchronized CompletableFuture<ProcessedFiles> updateFuture() {
            if (this.future.isDone() && !this.future.isCancelled() && !this.future.isCompletedExceptionally()) {
                ProcessedFiles pf = this._get();
                if (pf.failedFiles.size() > 0) {
                    this.initiateProcessing(pf);
                }
            }
            return this.future;
        }

        synchronized void initiateProcessing() {
            Preconditions.checkState((this.future == null ? 1 : 0) != 0);
            this.initiateProcessing(null);
        }

        @Override
        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            boolean canceled = this.future.cancel(mayInterruptIfRunning);
            if (canceled) {
                this.cancelFlag.set(true);
            }
            return canceled;
        }

        @Override
        public synchronized boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public synchronized boolean isDone() {
            this.updateFuture();
            if (this.future.isDone()) {
                if (this.future.isCancelled() || this.future.isCompletedExceptionally()) {
                    return true;
                }
                ProcessedFiles pf = this._get();
                if (pf.failedFiles.size() == 0) {
                    return true;
                }
                this.updateFuture();
            }
            return false;
        }

        @Override
        public SummaryCollection get() throws InterruptedException, ExecutionException {
            CompletableFuture<ProcessedFiles> futureRef = this.updateFuture();
            ProcessedFiles processedFiles = futureRef.get();
            while (processedFiles.failedFiles.size() > 0) {
                futureRef = this.updateFuture();
                processedFiles = futureRef.get();
            }
            return processedFiles.summaries;
        }

        @Override
        public SummaryCollection get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long nanosLeft = unit.toNanos(timeout);
            CompletableFuture<ProcessedFiles> futureRef = this.updateFuture();
            long t1 = System.nanoTime();
            ProcessedFiles processedFiles = futureRef.get(Long.max(1L, nanosLeft), TimeUnit.NANOSECONDS);
            long t2 = System.nanoTime();
            nanosLeft -= t2 - t1;
            while (processedFiles.failedFiles.size() > 0) {
                futureRef = this.updateFuture();
                t1 = System.nanoTime();
                processedFiles = futureRef.get(Long.max(1L, nanosLeft), TimeUnit.NANOSECONDS);
                t2 = System.nanoTime();
                nanosLeft -= t2 - t1;
            }
            return processedFiles.summaries;
        }
    }

    private class FilesProcessor
    implements Supplier<ProcessedFiles> {
        HostAndPort location;
        Map<String, List<TRowRange>> allFiles;
        private TInfo tinfo;
        private AtomicBoolean cancelFlag;

        public FilesProcessor(TInfo tinfo, HostAndPort location, Map<String, List<TRowRange>> allFiles, AtomicBoolean cancelFlag) {
            this.location = location;
            this.allFiles = allFiles;
            this.tinfo = tinfo;
            this.cancelFlag = cancelFlag;
        }

        /*
         * Exception decompiling
         */
        @Override
        public ProcessedFiles get() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static class ProcessedFiles {
        final SummaryCollection summaries = new SummaryCollection();
        final Set<String> failedFiles = new HashSet<String>();

        public ProcessedFiles() {
        }

        public ProcessedFiles(SummaryCollection summaries, SummarizerFactory factory) {
            this();
            this.summaries.merge(summaries, factory);
        }

        static ProcessedFiles merge(ProcessedFiles pf1, ProcessedFiles pf2, SummarizerFactory factory) {
            ProcessedFiles ret = new ProcessedFiles();
            ret.failedFiles.addAll(pf1.failedFiles);
            ret.failedFiles.addAll(pf2.failedFiles);
            ret.summaries.merge(pf1.summaries, factory);
            ret.summaries.merge(pf2.summaries, factory);
            return ret;
        }
    }
}

