/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.singletons;

import org.apache.accumulo.core.singletons.SingletonManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonReservation
implements AutoCloseable {
    protected volatile boolean closed = false;
    private static Logger log = LoggerFactory.getLogger(SingletonReservation.class);
    private final Exception e = new Exception();
    private static final SingletonReservation NOOP = new NoopSingletonReservation();

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        SingletonManager.releaseRerservation();
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                log.warn("An Accumulo Client was garbage collected without being closed.", (Throwable)this.e);
            }
        }
        finally {
            super.finalize();
        }
    }

    public static SingletonReservation noop() {
        return NOOP;
    }

    private static class NoopSingletonReservation
    extends SingletonReservation {
        NoopSingletonReservation() {
            this.closed = true;
        }
    }
}

