/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.singletons;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.singletons.SingletonReservation;
import org.apache.accumulo.core.singletons.SingletonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonManager {
    private static final Logger log = LoggerFactory.getLogger(SingletonManager.class);
    private static long reservations;
    private static Mode mode;
    private static boolean enabled;
    private static boolean transitionedFromClientToConnector;
    private static List<SingletonService> services;

    @VisibleForTesting
    static void reset() {
        reservations = 0L;
        mode = Mode.CLIENT;
        enabled = true;
        transitionedFromClientToConnector = false;
        services = new ArrayList<SingletonService>();
    }

    private static void enable(SingletonService service) {
        try {
            service.enable();
        }
        catch (RuntimeException e) {
            log.error("Failed to enable singleton service ", (Throwable)e);
        }
    }

    private static void disable(SingletonService service) {
        try {
            service.disable();
        }
        catch (RuntimeException e) {
            log.error("Failed to disable singleton service", (Throwable)e);
        }
    }

    public static synchronized void register(SingletonService service) {
        if (enabled && !service.isEnabled()) {
            SingletonManager.enable(service);
        }
        if (!enabled && service.isEnabled()) {
            SingletonManager.disable(service);
        }
        services.add(service);
    }

    public static synchronized SingletonReservation getClientReservation() {
        Preconditions.checkState((reservations >= 0L ? 1 : 0) != 0);
        ++reservations;
        SingletonManager.transition();
        return new SingletonReservation();
    }

    static synchronized void releaseRerservation() {
        Preconditions.checkState((reservations > 0L ? 1 : 0) != 0);
        --reservations;
        SingletonManager.transition();
    }

    @VisibleForTesting
    public static long getReservationCount() {
        return reservations;
    }

    public static synchronized void setMode(Mode mode) {
        if (SingletonManager.mode == Mode.CLIENT && mode == Mode.CONNECTOR) {
            if (transitionedFromClientToConnector) {
                throw new IllegalStateException("Can only transition from " + (Object)((Object)Mode.CLIENT) + " to " + (Object)((Object)Mode.CONNECTOR) + " once.  This error indicates that org.apache.accumulo.core.util.CleanUp.shutdownNow() was called and then later a Connector was created.  Connectors can not be created after CleanUp.shutdownNow() is called.");
            }
            transitionedFromClientToConnector = true;
        }
        if (SingletonManager.mode != Mode.SERVER) {
            SingletonManager.mode = mode;
        }
        SingletonManager.transition();
    }

    @VisibleForTesting
    public static synchronized Mode getMode() {
        return mode;
    }

    private static void transition() {
        if (enabled && reservations == 0L && mode == Mode.CLIENT) {
            for (SingletonService service : services) {
                SingletonManager.disable(service);
            }
            enabled = false;
        }
        if (!enabled && (mode == Mode.CONNECTOR || mode == Mode.SERVER || mode == Mode.CLIENT && reservations > 0L)) {
            for (SingletonService service : services) {
                SingletonManager.enable(service);
            }
            enabled = true;
        }
    }

    static {
        SingletonManager.reset();
    }

    public static enum Mode {
        CLIENT,
        SERVER,
        CONNECTOR;

    }
}

