/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.security;

import java.util.ArrayList;
import java.util.List;

public enum TablePermission {
    READ(2),
    WRITE(3),
    BULK_IMPORT(4),
    ALTER_TABLE(5),
    GRANT(6),
    DROP_TABLE(7),
    GET_SUMMARIES(8);

    private final byte permID;
    private static final TablePermission[] mapping;

    private TablePermission(byte id) {
        this.permID = id;
    }

    public byte getId() {
        return this.permID;
    }

    public static List<String> printableValues() {
        TablePermission[] a = TablePermission.values();
        ArrayList<String> list = new ArrayList<String>(a.length);
        for (TablePermission p : a) {
            list.add("Table." + (Object)((Object)p));
        }
        return list;
    }

    public static TablePermission getPermissionById(byte id) {
        TablePermission result = mapping[id];
        if (result != null) {
            return result;
        }
        throw new IndexOutOfBoundsException("No such permission");
    }

    static {
        mapping = new TablePermission[9];
        TablePermission[] tablePermissionArray = TablePermission.values();
        int n = tablePermissionArray.length;
        for (int i = 0; i < n; ++i) {
            TablePermission perm;
            TablePermission.mapping[perm.permID] = perm = tablePermissionArray[i];
        }
    }
}

