/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.rpc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.spi.SelectorProvider;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.hadoop.net.NetUtils;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTimeoutTransport {
    private static final Logger log = LoggerFactory.getLogger(TTimeoutTransport.class);
    private static final TTimeoutTransport INSTANCE = new TTimeoutTransport();
    private volatile Method GET_INPUT_STREAM_METHOD = null;

    private TTimeoutTransport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getNetUtilsInputStreamMethod() {
        if (this.GET_INPUT_STREAM_METHOD == null) {
            TTimeoutTransport tTimeoutTransport = this;
            synchronized (tTimeoutTransport) {
                if (this.GET_INPUT_STREAM_METHOD == null) {
                    try {
                        this.GET_INPUT_STREAM_METHOD = NetUtils.class.getMethod("getInputStream", Socket.class, Long.TYPE);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.GET_INPUT_STREAM_METHOD;
    }

    private InputStream getInputStream(Socket socket, long timeout) throws IOException {
        try {
            return (InputStream)this.getNetUtilsInputStreamMethod().invoke(null, socket, timeout);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static TTransport create(HostAndPort addr, long timeoutMillis) throws IOException {
        return INSTANCE.createInternal(new InetSocketAddress(addr.getHost(), addr.getPort()), timeoutMillis);
    }

    public static TTransport create(SocketAddress addr, long timeoutMillis) throws IOException {
        return INSTANCE.createInternal(addr, timeoutMillis);
    }

    protected TTransport createInternal(SocketAddress addr, long timeoutMillis) throws IOException {
        Socket socket = null;
        socket = this.openSocket(addr);
        assert (socket != null);
        try {
            InputStream input = this.wrapInputStream(socket, timeoutMillis);
            OutputStream output = this.wrapOutputStream(socket, timeoutMillis);
            return new TIOStreamTransport(input, output);
        }
        catch (IOException e) {
            try {
                socket.close();
            }
            catch (IOException ioe) {
                log.error("Failed to close socket after unsuccessful I/O stream setup", (Throwable)e);
            }
            throw e;
        }
    }

    protected InputStream wrapInputStream(Socket socket, long timeoutMillis) throws IOException {
        return new BufferedInputStream(this.getInputStream(socket, timeoutMillis), 10240);
    }

    protected OutputStream wrapOutputStream(Socket socket, long timeoutMillis) throws IOException {
        return new BufferedOutputStream(NetUtils.getOutputStream((Socket)socket, (long)timeoutMillis), 10240);
    }

    protected Socket openSocket(SocketAddress addr) throws IOException {
        Socket socket = null;
        try {
            socket = this.openSocketChannel();
            socket.setSoLinger(false, 0);
            socket.setTcpNoDelay(true);
            socket.connect(addr);
            return socket;
        }
        catch (IOException e) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ioe) {
                log.error("Failed to close socket after unsuccessful open.", (Throwable)e);
            }
            throw e;
        }
    }

    protected Socket openSocketChannel() throws IOException {
        return SelectorProvider.provider().openSocketChannel().socket();
    }
}

