/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.replication;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.data.TableId;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class ReplicationTarget
implements Writable {
    private String peerName;
    private String remoteIdentifier;
    private TableId sourceTableId;

    public ReplicationTarget() {
    }

    public ReplicationTarget(String peerName, String remoteIdentifier, TableId sourceTableId) {
        this.peerName = peerName;
        this.remoteIdentifier = remoteIdentifier;
        this.sourceTableId = sourceTableId;
    }

    public String getPeerName() {
        return this.peerName;
    }

    public void setPeerName(String peerName) {
        this.peerName = peerName;
    }

    public String getRemoteIdentifier() {
        return this.remoteIdentifier;
    }

    public void setRemoteIdentifier(String remoteIdentifier) {
        this.remoteIdentifier = remoteIdentifier;
    }

    public TableId getSourceTableId() {
        return this.sourceTableId;
    }

    public void setSourceTableId(TableId sourceTableId) {
        this.sourceTableId = sourceTableId;
    }

    public void write(DataOutput out) throws IOException {
        if (this.peerName == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            WritableUtils.writeString((DataOutput)out, (String)this.peerName);
        }
        if (this.remoteIdentifier == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            WritableUtils.writeString((DataOutput)out, (String)this.remoteIdentifier);
        }
        if (this.sourceTableId == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            WritableUtils.writeString((DataOutput)out, (String)this.sourceTableId.canonical());
        }
    }

    public void readFields(DataInput in) throws IOException {
        if (in.readBoolean()) {
            this.peerName = WritableUtils.readString((DataInput)in);
        }
        if (in.readBoolean()) {
            this.remoteIdentifier = WritableUtils.readString((DataInput)in);
        }
        if (in.readBoolean()) {
            this.sourceTableId = TableId.of(WritableUtils.readString((DataInput)in));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Remote Name: ").append(this.peerName).append(" Remote identifier: ").append(this.remoteIdentifier).append(" Source Table ID: ").append(this.sourceTableId);
        return sb.toString();
    }

    public int hashCode() {
        return this.peerName.hashCode() ^ this.remoteIdentifier.hashCode() ^ this.sourceTableId.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ReplicationTarget) {
            ReplicationTarget other = (ReplicationTarget)o;
            return this.peerName.equals(other.peerName) && this.remoteIdentifier.equals(other.remoteIdentifier) && this.sourceTableId.equals(other.sourceTableId);
        }
        return false;
    }

    public static ReplicationTarget from(Text t) {
        ReplicationTarget target = new ReplicationTarget();
        DataInputBuffer buffer = new DataInputBuffer();
        buffer.reset(t.getBytes(), t.getLength());
        try {
            target.readFields((DataInput)buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return target;
    }

    public static ReplicationTarget from(String s) {
        ReplicationTarget target = new ReplicationTarget();
        DataInputBuffer buffer = new DataInputBuffer();
        buffer.reset(s.getBytes(StandardCharsets.UTF_8), s.length());
        try {
            target.readFields((DataInput)buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return target;
    }

    public Text toText() {
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            this.write((DataOutput)buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Text t = new Text();
        t.set(buffer.getData(), 0, buffer.getLength());
        return t;
    }
}

