/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.replication;

import com.google.common.base.Preconditions;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.lexicoder.ULongLexicoder;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationSchema {
    private static final Logger log = LoggerFactory.getLogger(ReplicationSchema.class);

    private static void _getFile(Key k, Text buff) {
        k.getRow(buff);
    }

    public static class OrderSection {
        public static final Text NAME = new Text("order");
        public static final Text ROW_SEPARATOR = new Text(new byte[]{0});
        private static final ULongLexicoder longEncoder = new ULongLexicoder();

        public static void getTableId(Key k, Text buff) {
            Objects.requireNonNull(k);
            Objects.requireNonNull(buff);
            k.getColumnQualifier(buff);
        }

        public static void limit(ScannerBase scanner) {
            scanner.fetchColumnFamily(NAME);
        }

        public static Mutation createMutation(String file, long timeInMillis) {
            Objects.requireNonNull(file);
            Preconditions.checkArgument((timeInMillis >= 0L ? 1 : 0) != 0, (Object)"timeInMillis must be greater than zero");
            byte[] rowPrefix = longEncoder.encode(timeInMillis);
            Text row = new Text(rowPrefix);
            Path p = new Path(file);
            String pathString = p.toUri().toString();
            log.trace("Normalized {} into {}", (Object)file, (Object)pathString);
            row.append((ROW_SEPARATOR + pathString).getBytes(StandardCharsets.UTF_8), 0, pathString.length() + ROW_SEPARATOR.getLength());
            return new Mutation(row);
        }

        public static Mutation add(Mutation m, TableId tableId, Value v) {
            m.put(NAME, new Text(tableId.canonical()), v);
            return m;
        }

        public static long getTimeClosed(Key k) {
            return OrderSection.getTimeClosed(k, new Text());
        }

        public static long getTimeClosed(Key k, Text buff) {
            int nextOffset;
            k.getRow(buff);
            int offset = 0;
            while ((nextOffset = buff.find(ROW_SEPARATOR.toString(), offset + 1)) != -1) {
                offset = nextOffset;
            }
            if (offset == -1) {
                throw new IllegalArgumentException("Row does not contain expected separator for OrderSection");
            }
            byte[] encodedLong = new byte[offset];
            System.arraycopy(buff.getBytes(), 0, encodedLong, 0, offset);
            return longEncoder.decode(encodedLong);
        }

        public static String getFile(Key k) {
            Text buff = new Text();
            return OrderSection.getFile(k, buff);
        }

        public static String getFile(Key k, Text buff) {
            int nextOffset;
            k.getRow(buff);
            int offset = 0;
            while ((nextOffset = buff.find(ROW_SEPARATOR.toString(), offset + 1)) != -1) {
                offset = nextOffset;
            }
            if (offset == -1) {
                throw new IllegalArgumentException("Row does not contain expected separator for OrderSection");
            }
            try {
                return Text.decode((byte[])buff.getBytes(), (int)(offset + 1), (int)(buff.getLength() - (offset + 1)));
            }
            catch (CharacterCodingException e) {
                throw new IllegalArgumentException("Could not decode file path", e);
            }
        }
    }

    public static class StatusSection {
        public static final Text NAME = new Text("repl");
        private static final ByteSequence BYTE_SEQ_NAME = new ArrayByteSequence("repl");

        public static TableId getTableId(Key k) {
            Objects.requireNonNull(k);
            return TableId.of(k.getColumnQualifier().toString());
        }

        public static void getFile(Key k, Text buff) {
            Objects.requireNonNull(k);
            Objects.requireNonNull(buff);
            Preconditions.checkArgument((boolean)BYTE_SEQ_NAME.equals(k.getColumnFamilyData()), (Object)"Given replication status key with incorrect colfam");
            ReplicationSchema._getFile(k, buff);
        }

        public static void limit(ScannerBase scanner) {
            scanner.fetchColumnFamily(NAME);
        }

        public static Mutation add(Mutation m, TableId tableId, Value v) {
            m.put(NAME, new Text(tableId.canonical()), v);
            return m;
        }
    }

    public static class WorkSection {
        public static final Text NAME = new Text("work");
        private static final ByteSequence BYTE_SEQ_NAME = new ArrayByteSequence("work");

        public static void getFile(Key k, Text buff) {
            Objects.requireNonNull(k);
            Objects.requireNonNull(buff);
            Preconditions.checkArgument((boolean)BYTE_SEQ_NAME.equals(k.getColumnFamilyData()), (Object)"Given replication work key with incorrect colfam");
            ReplicationSchema._getFile(k, buff);
        }

        public static ReplicationTarget getTarget(Key k, Text buff) {
            Preconditions.checkArgument((boolean)BYTE_SEQ_NAME.equals(k.getColumnFamilyData()), (Object)"Given replication work key with incorrect colfam");
            k.getColumnQualifier(buff);
            return ReplicationTarget.from(buff);
        }

        public static void limit(ScannerBase scanner) {
            scanner.fetchColumnFamily(NAME);
        }

        public static Mutation add(Mutation m, Text serializedTarget, Value v) {
            m.put(NAME, serializedTarget, v);
            return m;
        }
    }
}

