/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata.schema;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;

public class TabletsMetadata
implements Iterable<TabletMetadata>,
AutoCloseable {
    private Scanner scanner;
    private Iterable<TabletMetadata> tablets;

    public static TableOptions builder() {
        return new Builder();
    }

    private TabletsMetadata(Scanner scanner, Iterable<TabletMetadata> tmi) {
        this.scanner = scanner;
        this.tablets = tmi;
    }

    @Override
    public void close() {
        this.scanner.close();
    }

    @Override
    public Iterator<TabletMetadata> iterator() {
        return this.tablets.iterator();
    }

    public Stream<TabletMetadata> stream() {
        return StreamSupport.stream(this.tablets.spliterator(), false);
    }

    private static class TabletMetadataIterator
    implements Iterator<TabletMetadata> {
        private boolean sawLast = false;
        private Iterator<TabletMetadata> iter;
        private Text endRow;

        TabletMetadataIterator(Iterator<TabletMetadata> source, Text endRow) {
            this.iter = source;
            this.endRow = endRow;
        }

        @Override
        public boolean hasNext() {
            return !this.sawLast && this.iter.hasNext();
        }

        @Override
        public TabletMetadata next() {
            if (this.sawLast) {
                throw new NoSuchElementException();
            }
            TabletMetadata next = this.iter.next();
            if (next.getExtent().contains((BinaryComparable)this.endRow)) {
                this.sawLast = true;
            }
            return next;
        }
    }

    public static interface TableRangeOptions
    extends Options {
        default public Options overlapping(byte[] startRow, byte[] endRow) {
            return this.overlapping(startRow == null ? null : new Text(startRow), endRow == null ? null : new Text(endRow));
        }

        public Options overlapping(Text var1, Text var2);
    }

    public static interface TableOptions {
        public Options forTablet(KeyExtent var1);

        public TableRangeOptions forTable(TableId var1);

        default public RangeOptions scanMetadataTable() {
            return this.scanTable(MetadataTable.NAME);
        }

        public RangeOptions scanTable(String var1);
    }

    public static interface RangeOptions
    extends Options {
        public Options overRange(Range var1);
    }

    public static interface Options {
        public TabletsMetadata build(AccumuloClient var1);

        public Options checkConsistency();

        public Options fetchCloned();

        public Options fetchCompactId();

        public Options fetchDir();

        public Options fetchFiles();

        public Options fetchFlushId();

        public Options fetchLast();

        public Options fetchLoaded();

        public Options fetchLocation();

        public Options fetchLogs();

        public Options fetchPrev();

        public Options fetchScans();

        public Options fetchTime();

        public Options saveKeyValues();
    }

    private static class Builder
    implements TableRangeOptions,
    TableOptions,
    RangeOptions,
    Options {
        private List<Text> families = new ArrayList<Text>();
        private List<ColumnFQ> qualifiers = new ArrayList<ColumnFQ>();
        private String table = MetadataTable.NAME;
        private Range range;
        private EnumSet<TabletMetadata.FetchedColumns> fetchedCols = EnumSet.noneOf(TabletMetadata.FetchedColumns.class);
        private Text endRow;
        private boolean checkConsistency = false;
        private boolean saveKeyValues;
        private TableId tableId;

        private Builder() {
        }

        @Override
        public TabletsMetadata build(AccumuloClient client) {
            try {
                IsolatedScanner scanner = new IsolatedScanner(client.createScanner(this.table, Authorizations.EMPTY));
                scanner.setRange(this.range);
                if (this.checkConsistency && !this.fetchedCols.contains((Object)TabletMetadata.FetchedColumns.PREV_ROW)) {
                    this.fetchPrev();
                }
                for (Text fam : this.families) {
                    scanner.fetchColumnFamily(fam);
                }
                for (ColumnFQ col : this.qualifiers) {
                    col.fetch(scanner);
                }
                if (this.families.size() == 0 && this.qualifiers.size() == 0) {
                    this.fetchedCols = EnumSet.allOf(TabletMetadata.FetchedColumns.class);
                }
                Iterable<TabletMetadata> tmi = TabletMetadata.convert(scanner, this.fetchedCols, this.checkConsistency, this.saveKeyValues);
                if (this.endRow != null) {
                    return new TabletsMetadata(scanner, () -> new TabletMetadataIterator(tmi.iterator(), this.endRow));
                }
                return new TabletsMetadata(scanner, tmi);
            }
            catch (TableNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Options checkConsistency() {
            this.checkConsistency = true;
            return this;
        }

        @Override
        public Options fetchCloned() {
            this.fetchedCols.add(TabletMetadata.FetchedColumns.CLONED);
            this.families.add(MetadataSchema.TabletsSection.ClonedColumnFamily.NAME);
            return this;
        }

        @Override
        public Options fetchCompactId() {
            this.fetchedCols.add(TabletMetadata.FetchedColumns.COMPACT_ID);
            this.qualifiers.add(MetadataSchema.TabletsSection.ServerColumnFamily.COMPACT_COLUMN);
            return this;
        }

        @Override
        public Options fetchDir() {
            this.fetchedCols.add(TabletMetadata.FetchedColumns.DIR);
            this.qualifiers.add(MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN);
            return this;
        }

        @Override
        public Options fetchFiles() {
            this.fetchedCols.add(TabletMetadata.FetchedColumns.FILES);
            this.families.add(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            return this;
        }

        @Override
        public Options fetchFlushId() {
            this.fetchedCols.add(TabletMetadata.FetchedColumns.FLUSH_ID);
            this.qualifiers.add(MetadataSchema.TabletsSection.ServerColumnFamily.FLUSH_COLUMN);
            return this;
        }

        @Override
        public Options fetchLast() {
            this.fetchedCols.add(TabletMetadata.FetchedColumns.LAST);
            this.families.add(MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME);
            return this;
        }

        @Override
        public Options fetchLoaded() {
            this.fetchedCols.add(TabletMetadata.FetchedColumns.LOADED);
            this.families.add(MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME);
            return this;
        }

        @Override
        public Options fetchLocation() {
            this.fetchedCols.add(TabletMetadata.FetchedColumns.LOCATION);
            this.families.add(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
            this.families.add(MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME);
            return this;
        }

        @Override
        public Options fetchLogs() {
            this.fetchedCols.add(TabletMetadata.FetchedColumns.LOGS);
            this.families.add(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
            return this;
        }

        @Override
        public Options fetchPrev() {
            this.fetchedCols.add(TabletMetadata.FetchedColumns.PREV_ROW);
            this.qualifiers.add(MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN);
            return this;
        }

        @Override
        public Options fetchScans() {
            this.fetchedCols.add(TabletMetadata.FetchedColumns.SCANS);
            this.families.add(MetadataSchema.TabletsSection.ScanFileColumnFamily.NAME);
            return this;
        }

        @Override
        public Options fetchTime() {
            this.fetchedCols.add(TabletMetadata.FetchedColumns.TIME);
            this.qualifiers.add(MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN);
            return this;
        }

        @Override
        public TableRangeOptions forTable(TableId tableId) {
            Preconditions.checkArgument((!tableId.equals(RootTable.ID) ? 1 : 0) != 0, (Object)("Getting tablet metadata for " + RootTable.NAME + " not supported at this time."));
            this.table = tableId.equals(MetadataTable.ID) ? RootTable.NAME : MetadataTable.NAME;
            this.tableId = tableId;
            this.range = MetadataSchema.TabletsSection.getRange(tableId);
            return this;
        }

        @Override
        public Options forTablet(KeyExtent extent) {
            this.forTable(extent.getTableId());
            this.range = new Range(extent.getMetadataEntry());
            return this;
        }

        @Override
        public Options overRange(Range range) {
            this.range = MetadataSchema.TabletsSection.getRange().clip(range);
            return this;
        }

        @Override
        public Options overlapping(Text startRow, Text endRow) {
            this.range = new KeyExtent(this.tableId, null, startRow).toMetadataRange();
            this.endRow = endRow;
            return this;
        }

        @Override
        public Options saveKeyValues() {
            this.saveKeyValues = true;
            return this;
        }

        @Override
        public RangeOptions scanTable(String tableName) {
            this.table = tableName;
            this.range = MetadataSchema.TabletsSection.getRange();
            return this;
        }
    }
}

