/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata.schema;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.TabletDeletedException;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkingIterator
implements Iterator<TabletMetadata> {
    private static final Logger log = LoggerFactory.getLogger(LinkingIterator.class);
    private Range range;
    private Function<Range, Iterator<TabletMetadata>> iteratorFactory;
    private Iterator<TabletMetadata> source;
    private TabletMetadata prevTablet = null;

    LinkingIterator(Function<Range, Iterator<TabletMetadata>> iteratorFactory, Range range) {
        this.range = range;
        this.iteratorFactory = iteratorFactory;
        this.source = iteratorFactory.apply(range);
    }

    @Override
    public boolean hasNext() {
        Text defaultTabletRow;
        boolean hasNext = this.source.hasNext();
        if (!hasNext && this.prevTablet != null && this.prevTablet.getEndRow() != null && this.range.contains(new Key(defaultTabletRow = MetadataSchema.TabletsSection.getRow(this.prevTablet.getTableId(), null)))) {
            throw new IllegalStateException("Scan range incudled default tablet, but did not see default tablet.  Last tablet seen : " + this.prevTablet.getExtent());
        }
        return hasNext;
    }

    static boolean goodTransition(TabletMetadata prev, TabletMetadata curr) {
        if (!curr.sawPrevEndRow()) {
            log.warn("Tablet {} had no prev end row.", (Object)curr.getExtent());
            return false;
        }
        if (!curr.getTableId().equals(prev.getTableId())) {
            if (prev.getEndRow() != null) {
                log.debug("Non-null end row for last tablet in table: " + prev.getExtent() + " " + curr.getExtent());
                return false;
            }
            if (curr.getPrevEndRow() != null) {
                log.debug("First tablet for table had prev end row {} {} ", (Object)prev.getExtent(), (Object)curr.getExtent());
                return false;
            }
        } else {
            if (prev.getEndRow() == null) {
                throw new IllegalStateException("Null end row for tablet in middle of table: " + prev.getExtent() + " " + curr.getExtent());
            }
            if (curr.getPrevEndRow() == null || !prev.getEndRow().equals((Object)curr.getPrevEndRow())) {
                log.debug("Tablets end row and prev end row not equals {} {} ", (Object)prev.getExtent(), (Object)curr.getExtent());
                return false;
            }
        }
        return true;
    }

    private void resetSource() {
        if (this.prevTablet == null) {
            log.debug("Resetting scanner to {}", (Object)this.range);
            this.source = this.iteratorFactory.apply(this.range);
        } else {
            Text prevMetaRow = MetadataSchema.TabletsSection.getRow(this.prevTablet.getTableId(), this.prevTablet.getEndRow());
            if (Iterators.size(this.iteratorFactory.apply(new Range(prevMetaRow))) == 0) {
                throw new TabletDeletedException("Tablet " + prevMetaRow + " was deleted while iterating");
            }
            Range seekRange = new Range(new Key(prevMetaRow).followingKey(PartialKey.ROW), true, this.range.getEndKey(), this.range.isEndKeyInclusive());
            log.debug("Resetting scanner to {}", (Object)seekRange);
            this.source = this.iteratorFactory.apply(seekRange);
        }
    }

    @Override
    public TabletMetadata next() {
        long sleepTime = 250L;
        TabletMetadata currTablet = null;
        while (currTablet == null) {
            TabletMetadata tmp = this.source.next();
            if (this.prevTablet == null) {
                if (tmp.sawPrevEndRow()) {
                    Text prevMetaRow = null;
                    KeyExtent extent = tmp.getExtent();
                    if (extent.getPrevEndRow() != null) {
                        prevMetaRow = MetadataSchema.TabletsSection.getRow(extent.getTableId(), extent.getPrevEndRow());
                    }
                    if (prevMetaRow == null || this.range.beforeStartKey(new Key(prevMetaRow))) {
                        currTablet = tmp;
                    } else {
                        log.debug("First tablet seen provides evidence of earlier tablet in range, retrying {} {} ", (Object)prevMetaRow, (Object)this.range);
                    }
                } else {
                    log.warn("Tablet has no prev end row " + tmp.getTableId() + " " + tmp.getEndRow());
                }
            } else if (LinkingIterator.goodTransition(this.prevTablet, tmp)) {
                currTablet = tmp;
            }
            if (currTablet != null) continue;
            UtilWaitThread.sleepUninterruptibly(sleepTime, TimeUnit.MILLISECONDS);
            this.resetSource();
            sleepTime = Math.min(2L * sleepTime, 5000L);
        }
        this.prevTablet = currTablet;
        return currTablet;
    }
}

