/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.clientImpl.AccumuloServerException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ScannerOptions;
import org.apache.accumulo.core.clientImpl.TabletLocator;
import org.apache.accumulo.core.clientImpl.TabletLocatorImpl;
import org.apache.accumulo.core.clientImpl.TabletServerBatchReaderIterator;
import org.apache.accumulo.core.clientImpl.ThriftScanner;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.iterators.user.WholeRowIterator;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataLocationObtainer
implements TabletLocatorImpl.TabletLocationObtainer {
    private static final Logger log = LoggerFactory.getLogger(MetadataLocationObtainer.class);
    private SortedSet<Column> locCols = new TreeSet<Column>();
    private ArrayList<Column> columns;

    public MetadataLocationObtainer() {
        this.locCols.add(new Column(TextUtil.getBytes(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME), null, null));
        this.locCols.add(MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.toColumn());
        this.columns = new ArrayList<Column>(this.locCols);
    }

    @Override
    public TabletLocator.TabletLocations lookupTablet(ClientContext context, TabletLocator.TabletLocation src, Text row, Text stopRow, TabletLocator parent) throws AccumuloSecurityException, AccumuloException {
        try {
            OpTimer timer = null;
            if (log.isTraceEnabled()) {
                log.trace("tid={} Looking up in {} row={} extent={} tserver={}", new Object[]{Thread.currentThread().getId(), src.tablet_extent.getTableId(), TextUtil.truncate(row), src.tablet_extent, src.tablet_location});
                timer = new OpTimer().start();
            }
            Range range = new Range(row, true, stopRow, true);
            TreeMap<Key, Value> encodedResults = new TreeMap<Key, Value>();
            TreeMap<Key, Value> results = new TreeMap<Key, Value>();
            ArrayList<IterInfo> serverSideIteratorList = new ArrayList<IterInfo>();
            serverSideIteratorList.add(new IterInfo(10000, WholeRowIterator.class.getName(), "WRI"));
            Map<String, Map<String, String>> serverSideIteratorOptions = Collections.emptyMap();
            boolean more = ThriftScanner.getBatchFromServer(context, range, src.tablet_extent, src.tablet_location, encodedResults, this.locCols, serverSideIteratorList, serverSideIteratorOptions, 1000, Authorizations.EMPTY, 0L, null);
            this.decodeRows(encodedResults, results);
            if (more && results.size() == 1) {
                range = new Range(results.lastKey().followingKey(PartialKey.ROW_COLFAM_COLQUAL_COLVIS_TIME), true, new Key(stopRow).followingKey(PartialKey.ROW), false);
                encodedResults.clear();
                more = ThriftScanner.getBatchFromServer(context, range, src.tablet_extent, src.tablet_location, encodedResults, this.locCols, serverSideIteratorList, serverSideIteratorOptions, 1000, Authorizations.EMPTY, 0L, null);
                this.decodeRows(encodedResults, results);
            }
            if (timer != null) {
                timer.stop();
                log.trace("tid={} Got {} results from {} in {}", new Object[]{Thread.currentThread().getId(), results.size(), src.tablet_extent, String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
            }
            return MetadataLocationObtainer.getMetadataLocationEntries(results);
        }
        catch (AccumuloServerException ase) {
            if (log.isTraceEnabled()) {
                log.trace("{} lookup failed, {} server side exception", (Object)src.tablet_extent.getTableId(), (Object)src.tablet_location);
            }
            throw ase;
        }
        catch (AccumuloException e) {
            if (log.isTraceEnabled()) {
                log.trace("{} lookup failed", (Object)src.tablet_extent.getTableId(), (Object)e);
            }
            parent.invalidateCache(context, src.tablet_location);
            return null;
        }
    }

    private void decodeRows(TreeMap<Key, Value> encodedResults, TreeMap<Key, Value> results) throws AccumuloException {
        for (Map.Entry<Key, Value> entry : encodedResults.entrySet()) {
            try {
                results.putAll(WholeRowIterator.decodeRow(entry.getKey(), entry.getValue()));
            }
            catch (IOException e) {
                throw new AccumuloException(e);
            }
        }
    }

    @Override
    public List<TabletLocator.TabletLocation> lookupTablets(ClientContext context, String tserver, Map<KeyExtent, List<Range>> tabletsRanges, TabletLocator parent) throws AccumuloSecurityException, AccumuloException {
        TreeMap<Key, Value> results = new TreeMap<Key, Value>();
        TabletServerBatchReaderIterator.ResultReceiver rr = entries -> {
            for (Map.Entry entry : entries) {
                try {
                    results.putAll(WholeRowIterator.decodeRow((Key)entry.getKey(), (Value)entry.getValue()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        ScannerOptions opts = null;
        try (SettableScannerOptions unsetOpts = new SettableScannerOptions();){
            opts = unsetOpts.setColumns(this.locCols);
        }
        HashMap<KeyExtent, List<Range>> unscanned = new HashMap<KeyExtent, List<Range>>();
        HashMap<KeyExtent, List<Range>> failures = new HashMap<KeyExtent, List<Range>>();
        try {
            TabletServerBatchReaderIterator.doLookup(context, tserver, tabletsRanges, failures, unscanned, rr, this.columns, opts, Authorizations.EMPTY);
            if (failures.size() > 0) {
                if (log.isTraceEnabled()) {
                    log.trace("lookupTablets failed for {} extents", (Object)failures.size());
                }
                parent.invalidateCache(failures.keySet());
            }
        }
        catch (IOException e) {
            log.trace("lookupTablets failed server={}", (Object)tserver, (Object)e);
            parent.invalidateCache(context, tserver);
        }
        catch (AccumuloServerException e) {
            log.trace("lookupTablets failed server={}", (Object)tserver, (Object)e);
            throw e;
        }
        return MetadataLocationObtainer.getMetadataLocationEntries(results).getLocations();
    }

    public static TabletLocator.TabletLocations getMetadataLocationEntries(SortedMap<Key, Value> entries) {
        Text location = null;
        Text session = null;
        Value prevRow = null;
        ArrayList<TabletLocator.TabletLocation> results = new ArrayList<TabletLocator.TabletLocation>();
        ArrayList<KeyExtent> locationless = new ArrayList<KeyExtent>();
        Text lastRowFromKey = new Text();
        Text colf = new Text();
        Text colq = new Text();
        for (Map.Entry<Key, Value> entry : entries.entrySet()) {
            Key key = entry.getKey();
            Value val = entry.getValue();
            if (key.compareRow(lastRowFromKey) != 0) {
                prevRow = null;
                location = null;
                session = null;
                key.getRow(lastRowFromKey);
            }
            colf = key.getColumnFamily(colf);
            colq = key.getColumnQualifier(colq);
            if (colf.equals((Object)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME) || colf.equals((Object)MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME)) {
                if (location != null) {
                    throw new IllegalStateException("Tablet has multiple locations : " + lastRowFromKey);
                }
                location = new Text(val.toString());
                session = new Text(colq);
            } else if (MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.equals(colf, colq)) {
                prevRow = new Value(val);
            }
            if (prevRow == null) continue;
            KeyExtent ke = new KeyExtent(key.getRow(), prevRow);
            if (location != null) {
                results.add(new TabletLocator.TabletLocation(ke, location.toString(), session.toString()));
            } else {
                locationless.add(ke);
            }
            location = null;
            prevRow = null;
        }
        return new TabletLocator.TabletLocations(results, locationless);
    }

    private static class SettableScannerOptions
    extends ScannerOptions {
        private SettableScannerOptions() {
        }

        public ScannerOptions setColumns(SortedSet<Column> locCols) {
            this.fetchedColumns = locCols;
            this.addScanIterator(new IteratorSetting(10000, "WRI", WholeRowIterator.class.getName()));
            return this;
        }
    }
}

