/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.system;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.HeapIterator;
import org.apache.accumulo.core.iterators.system.InterruptibleIterator;
import org.apache.commons.lang3.mutable.MutableLong;

public class LocalityGroupIterator
extends HeapIterator
implements InterruptibleIterator {
    private static final Collection<ByteSequence> EMPTY_CF_SET = Collections.emptySet();
    private final LocalityGroupContext lgContext;
    private LocalityGroupSeekCache lgCache;
    private AtomicBoolean interruptFlag;

    public LocalityGroupIterator(LocalityGroup[] groups) {
        super(groups.length);
        this.lgContext = new LocalityGroupContext(groups);
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        throw new UnsupportedOperationException();
    }

    static final Collection<LocalityGroup> _seek(HeapIterator hiter, LocalityGroupContext lgContext, Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        HashSet<ByteSequence> cfSet;
        hiter.clear();
        if (columnFamilies.size() > 0) {
            if (columnFamilies instanceof Set) {
                cfSet = (HashSet<ByteSequence>)columnFamilies;
            } else {
                cfSet = new HashSet<ByteSequence>();
                cfSet.addAll(columnFamilies);
            }
        } else {
            cfSet = Collections.emptySet();
        }
        List<LocalityGroup> groups = Collections.emptyList();
        if (cfSet.size() == 0) {
            if (!inclusive) {
                groups = lgContext.groups;
            }
        } else {
            groups = new HashSet();
            if (lgContext.defaultGroup != null) {
                if (inclusive) {
                    if (!lgContext.groupByCf.keySet().containsAll(cfSet)) {
                        groups.add(lgContext.defaultGroup);
                    }
                } else {
                    groups.add(lgContext.defaultGroup);
                }
            }
            if (!inclusive) {
                for (Map.Entry entry : lgContext.groupByCf.entrySet()) {
                    if (cfSet.contains(entry.getKey())) continue;
                    groups.add((LocalityGroup)entry.getValue());
                }
            } else if (lgContext.groupByCf.size() <= cfSet.size()) {
                for (Map.Entry entry : lgContext.groupByCf.entrySet()) {
                    if (!cfSet.contains(entry.getKey())) continue;
                    groups.add((LocalityGroup)entry.getValue());
                }
            } else {
                for (ByteSequence byteSequence : cfSet) {
                    LocalityGroup group = lgContext.groupByCf.get(byteSequence);
                    if (group == null) continue;
                    groups.add(group);
                }
            }
        }
        for (LocalityGroup localityGroup : groups) {
            localityGroup.getIterator().seek(range, EMPTY_CF_SET, false);
            hiter.addSource(localityGroup.getIterator());
        }
        return groups;
    }

    public static LocalityGroupSeekCache seek(HeapIterator hiter, LocalityGroupContext lgContext, Range range, Collection<ByteSequence> columnFamilies, boolean inclusive, LocalityGroupSeekCache lgSeekCache) throws IOException {
        if (lgSeekCache == null) {
            lgSeekCache = new LocalityGroupSeekCache();
        }
        boolean sameArgs = false;
        ImmutableSet cfSet = null;
        if (lgSeekCache.lastUsed != null && inclusive == lgSeekCache.lastInclusive) {
            if (columnFamilies instanceof Set) {
                sameArgs = lgSeekCache.lastColumnFamilies.equals(columnFamilies);
            } else {
                cfSet = ImmutableSet.copyOf(columnFamilies);
                sameArgs = lgSeekCache.lastColumnFamilies.equals((Object)cfSet);
            }
        }
        if (sameArgs) {
            hiter.clear();
            for (LocalityGroup lgr : lgSeekCache.lastUsed) {
                lgr.getIterator().seek(range, EMPTY_CF_SET, false);
                hiter.addSource(lgr.getIterator());
            }
        } else {
            lgSeekCache.lastColumnFamilies = cfSet == null ? ImmutableSet.copyOf(columnFamilies) : cfSet;
            lgSeekCache.lastInclusive = inclusive;
            lgSeekCache.lastUsed = LocalityGroupIterator._seek(hiter, lgContext, range, columnFamilies, inclusive);
        }
        return lgSeekCache;
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.lgCache = LocalityGroupIterator.seek(this, this.lgContext, range, columnFamilies, inclusive, this.lgCache);
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        LocalityGroup[] groupsCopy = new LocalityGroup[this.lgContext.groups.size()];
        for (int i = 0; i < this.lgContext.groups.size(); ++i) {
            groupsCopy[i] = new LocalityGroup(this.lgContext.groups.get(i), env);
            if (this.interruptFlag == null) continue;
            groupsCopy[i].getIterator().setInterruptFlag(this.interruptFlag);
        }
        return new LocalityGroupIterator(groupsCopy);
    }

    @Override
    public void setInterruptFlag(AtomicBoolean flag) {
        this.interruptFlag = flag;
        for (LocalityGroup lgr : this.lgContext.groups) {
            lgr.getIterator().setInterruptFlag(flag);
        }
    }

    public static class LocalityGroupSeekCache {
        private ImmutableSet<ByteSequence> lastColumnFamilies;
        private volatile boolean lastInclusive;
        private Collection<LocalityGroup> lastUsed;

        public ImmutableSet<ByteSequence> getLastColumnFamilies() {
            return this.lastColumnFamilies;
        }

        public boolean isLastInclusive() {
            return this.lastInclusive;
        }

        public Collection<LocalityGroup> getLastUsed() {
            return this.lastUsed;
        }

        public int getNumLGSeeked() {
            return this.lastUsed == null ? 0 : this.lastUsed.size();
        }
    }

    public static class LocalityGroupContext {
        final List<LocalityGroup> groups;
        final LocalityGroup defaultGroup;
        final Map<ByteSequence, LocalityGroup> groupByCf;

        public LocalityGroupContext(LocalityGroup[] groups) {
            this.groups = Collections.unmodifiableList(Arrays.asList(groups));
            this.groupByCf = new HashMap<ByteSequence, LocalityGroup>();
            LocalityGroup foundDefault = null;
            for (LocalityGroup group : groups) {
                if (group.isDefaultLocalityGroup && group.columnFamilies == null) {
                    if (foundDefault != null) {
                        throw new IllegalStateException("Found multiple default locality groups");
                    }
                    foundDefault = group;
                    continue;
                }
                for (Map.Entry<ByteSequence, MutableLong> entry : group.columnFamilies.entrySet()) {
                    if (entry.getValue().longValue() <= 0L) continue;
                    if (this.groupByCf.containsKey(entry.getKey())) {
                        throw new IllegalStateException("Found the same cf in multiple locality groups");
                    }
                    this.groupByCf.put(entry.getKey(), group);
                }
            }
            this.defaultGroup = foundDefault;
        }
    }

    public static class LocalityGroup {
        protected boolean isDefaultLocalityGroup;
        protected Map<ByteSequence, MutableLong> columnFamilies;
        private InterruptibleIterator iterator;

        private LocalityGroup(LocalityGroup localityGroup, IteratorEnvironment env) {
            this(localityGroup.columnFamilies, localityGroup.isDefaultLocalityGroup);
            this.iterator = (InterruptibleIterator)localityGroup.iterator.deepCopy(env);
        }

        public LocalityGroup(InterruptibleIterator iterator, Map<ByteSequence, MutableLong> columnFamilies, boolean isDefaultLocalityGroup) {
            this(columnFamilies, isDefaultLocalityGroup);
            this.iterator = iterator;
        }

        public LocalityGroup(Map<ByteSequence, MutableLong> columnFamilies, boolean isDefaultLocalityGroup) {
            this.isDefaultLocalityGroup = isDefaultLocalityGroup;
            this.columnFamilies = columnFamilies;
        }

        public InterruptibleIterator getIterator() {
            return this.iterator;
        }
    }
}

