/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.system;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.ServerWrappingIterator;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public class DeletingIterator
extends ServerWrappingIterator {
    private boolean propogateDeletes;
    private Key workKey = new Key();

    public DeletingIterator deepCopy(IteratorEnvironment env) {
        return new DeletingIterator(this, env);
    }

    private DeletingIterator(DeletingIterator other, IteratorEnvironment env) {
        super(other.source.deepCopy(env));
        this.propogateDeletes = other.propogateDeletes;
    }

    private DeletingIterator(SortedKeyValueIterator<Key, Value> iterator, boolean propogateDeletes) {
        super(iterator);
        this.propogateDeletes = propogateDeletes;
    }

    @Override
    public void next() throws IOException {
        if (((Key)this.source.getTopKey()).isDeleted()) {
            this.skipRowColumn();
        } else {
            this.source.next();
        }
        this.findTop();
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        Range seekRange = IteratorUtil.maximizeStartKeyTimeStamp(range);
        this.source.seek(seekRange, columnFamilies, inclusive);
        this.findTop();
        if (range.getStartKey() != null) {
            while (this.source.hasTop() && ((Key)this.source.getTopKey()).compareTo(range.getStartKey(), PartialKey.ROW_COLFAM_COLQUAL_COLVIS_TIME) < 0) {
                this.next();
            }
            while (this.hasTop() && range.beforeStartKey(this.getTopKey())) {
                this.next();
            }
        }
    }

    private void findTop() throws IOException {
        if (!this.propogateDeletes) {
            while (this.source.hasTop() && ((Key)this.source.getTopKey()).isDeleted()) {
                this.skipRowColumn();
            }
        }
    }

    private void skipRowColumn() throws IOException {
        this.workKey.set((Key)this.source.getTopKey());
        Key keyToSkip = this.workKey;
        this.source.next();
        while (this.source.hasTop() && ((Key)this.source.getTopKey()).equals(keyToSkip, PartialKey.ROW_COLFAM_COLQUAL_COLVIS)) {
            this.source.next();
        }
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) {
        throw new UnsupportedOperationException();
    }

    public static SortedKeyValueIterator<Key, Value> wrap(SortedKeyValueIterator<Key, Value> source, boolean propogateDeletes, Behavior behavior) {
        switch (behavior) {
            case PROCESS: {
                return new DeletingIterator(source, propogateDeletes);
            }
            case FAIL: {
                return new ServerWrappingIterator((SortedKeyValueIterator)source){

                    @Override
                    public Key getTopKey() {
                        Key top = (Key)this.source.getTopKey();
                        if (top.isDeleted()) {
                            throw new IllegalStateException("Saw unexpected delete " + top);
                        }
                        return top;
                    }
                };
            }
        }
        throw new IllegalArgumentException("Unknown behavior " + (Object)((Object)behavior));
    }

    public static Behavior getBehavior(AccumuloConfiguration conf) {
        return Behavior.valueOf(conf.get(Property.TABLE_DELETE_BEHAVIOR).toUpperCase());
    }

    public static enum Behavior {
        PROCESS,
        FAIL;

    }
}

