/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrIterator
implements SortedKeyValueIterator<Key, Value>,
OptionDescriber {
    private static final Logger LOG = LoggerFactory.getLogger(OrIterator.class);
    public static final String COLUMNS_KEY = "or.iterator.columns";
    private TermSource currentTerm;
    private List<TermSource> sources;
    private PriorityQueue<TermSource> sorted = new PriorityQueue(5);

    public OrIterator() {
        this.sources = Collections.emptyList();
    }

    private OrIterator(OrIterator other, IteratorEnvironment env) {
        ArrayList<TermSource> copiedSources = new ArrayList<TermSource>();
        for (TermSource TS : other.sources) {
            copiedSources.add(new TermSource(TS.iter.deepCopy(env), new Text(TS.term)));
        }
        this.sources = Collections.unmodifiableList(copiedSources);
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new OrIterator(this, env);
    }

    public void setTerms(SortedKeyValueIterator<Key, Value> source, Collection<String> terms, IteratorEnvironment env) {
        ArrayList<TermSource> newTerms = new ArrayList<TermSource>();
        for (String term : terms) {
            newTerms.add(new TermSource(source.deepCopy(env), new Text(term)));
        }
        this.sources = Collections.unmodifiableList(newTerms);
    }

    @Override
    public final void next() throws IOException {
        LOG.trace("next()");
        if (this.currentTerm == null) {
            return;
        }
        this.currentTerm.iter.next();
        boolean currentTermHasMoreEntries = this.currentTerm.hasEntryForTerm();
        if (!this.sorted.isEmpty()) {
            if (currentTermHasMoreEntries) {
                this.sorted.add(this.currentTerm);
            }
            this.currentTerm = this.sorted.poll();
        } else if (!currentTermHasMoreEntries) {
            this.currentTerm = null;
        }
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        LOG.trace("seek() range={}", (Object)range);
        if (this.sources.isEmpty()) {
            this.currentTerm = null;
            return;
        }
        if (this.sources.size() == 1) {
            this.currentTerm = this.sources.get(0);
            this.currentTerm.seek(range);
            if (!this.currentTerm.hasEntryForTerm()) {
                this.currentTerm = null;
            }
            return;
        }
        this.sorted.clear();
        for (TermSource ts : this.sources) {
            ts.seek(range);
            if (ts.hasEntryForTerm()) {
                LOG.trace("Retaining TermSource for {}", (Object)ts);
                this.sorted.add(ts);
                continue;
            }
            LOG.trace("Not adding TermSource to heap for {}", (Object)ts);
        }
        this.currentTerm = this.sorted.poll();
    }

    @Override
    public final Key getTopKey() {
        Key k = (Key)this.currentTerm.iter.getTopKey();
        LOG.trace("getTopKey() = {}", (Object)k);
        return k;
    }

    @Override
    public final Value getTopValue() {
        Value v = (Value)this.currentTerm.iter.getTopValue();
        LOG.trace("getTopValue() = {}", (Object)v);
        return v;
    }

    @Override
    public final boolean hasTop() {
        LOG.trace("hasTop()");
        return this.currentTerm != null;
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        LOG.trace("init()");
        String columnsValue = options.get(COLUMNS_KEY);
        if (columnsValue == null) {
            throw new IllegalArgumentException("or.iterator.columns was not provided in the iterator configuration");
        }
        String[] columns = StringUtils.split((String)columnsValue, (char)',');
        this.setTerms(source, Arrays.asList(columns), env);
        LOG.trace("Set sources: {}", this.sources);
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(COLUMNS_KEY, "A comma-separated list of families");
        return new OptionDescriber.IteratorOptions("OrIterator", "Produces a sorted stream of qualifiers based on families", options, Collections.emptyList());
    }

    @Override
    public boolean validateOptions(Map<String, String> options) {
        return options.get(COLUMNS_KEY) != null;
    }

    protected static class TermSource
    implements Comparable<TermSource> {
        private final SortedKeyValueIterator<Key, Value> iter;
        private final Text term;
        private final Collection<ByteSequence> seekColfams;
        private Range currentRange;

        public TermSource(TermSource other) {
            this.iter = Objects.requireNonNull(other.iter);
            this.term = Objects.requireNonNull(other.term);
            this.seekColfams = Objects.requireNonNull(other.seekColfams);
            this.currentRange = Objects.requireNonNull(other.currentRange);
        }

        public TermSource(SortedKeyValueIterator<Key, Value> iter, Text term) {
            this.iter = Objects.requireNonNull(iter);
            this.term = Objects.requireNonNull(term);
            this.seekColfams = Collections.singletonList(new ArrayByteSequence(term.getBytes(), 0, term.getLength()));
            this.currentRange = null;
        }

        public int hashCode() {
            return Objects.hashCode(this.iter.getTopKey().getColumnQualifier());
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof TermSource && this.compareTo((TermSource)obj) == 0;
        }

        @Override
        public int compareTo(TermSource o) {
            return this.iter.getTopKey().compareColumnQualifier(o.iter.getTopKey().getColumnQualifier());
        }

        public void seek(Range originalRange) throws IOException {
            if (!originalRange.isInfiniteStartKey()) {
                Key originalStartKey = originalRange.getStartKey();
                Key newKey = new Key(originalStartKey.getRow(), this.term, originalStartKey.getColumnQualifier(), originalStartKey.getTimestamp());
                this.currentRange = new Range(newKey, originalRange.isStartKeyInclusive(), originalRange.getEndKey(), originalRange.isEndKeyInclusive());
            } else {
                this.currentRange = originalRange;
            }
            LOG.trace("Seeking {} to {}", (Object)this, (Object)this.currentRange);
            this.iter.seek(this.currentRange, this.seekColfams, true);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("TermSource{term=").append(this.term).append(", currentRange=").append(this.currentRange).append("}");
            return sb.toString();
        }

        boolean hasEntryForTerm() {
            if (!this.iter.hasTop()) {
                return false;
            }
            return this.currentRange.contains(this.iter.getTopKey());
        }
    }
}

