/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.data;

import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.io.Text;

public class KeyBuilder {

    static class KeyBuilderImpl
    implements RowStep,
    ColumnFamilyStep,
    ColumnQualifierStep,
    ColumnVisibilityStep {
        protected static final byte[] EMPTY_BYTES = new byte[0];
        private final boolean copyBytes;
        private byte[] row = EMPTY_BYTES;
        private int rowOffset = 0;
        private int rowLength = 0;
        private byte[] family = EMPTY_BYTES;
        private int familyOffset = 0;
        private int familyLength = 0;
        private byte[] qualifier = EMPTY_BYTES;
        private int qualifierOffset = 0;
        private int qualifierLength = 0;
        private byte[] visibility = EMPTY_BYTES;
        private int visibilityOffset = 0;
        private int visibilityLength = 0;
        private long timestamp = Long.MAX_VALUE;
        private boolean deleted = false;

        KeyBuilderImpl(boolean copyBytes) {
            this.copyBytes = copyBytes;
        }

        private byte[] copyBytesIfNeeded(byte[] bytes, int offset, int length) {
            return Key.copyIfNeeded(bytes, offset, length, this.copyBytes);
        }

        private byte[] encodeCharSequence(CharSequence chars) {
            CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            try {
                return encoder.encode(CharBuffer.wrap(chars)).array();
            }
            catch (CharacterCodingException ex) {
                throw new RuntimeException("KeyBuilder supports only CharSequences encoded in UTF-8", ex);
            }
        }

        @Override
        public ColumnFamilyStep row(byte[] row, int offset, int length) {
            this.row = this.copyBytesIfNeeded(row, offset, length);
            this.rowOffset = this.copyBytes ? 0 : offset;
            this.rowLength = this.copyBytes ? this.row.length : length;
            return this;
        }

        @Override
        public ColumnFamilyStep row(byte[] row) {
            return this.row(row, 0, row.length);
        }

        @Override
        public ColumnFamilyStep row(Text row) {
            return this.row(row.getBytes(), 0, row.getLength());
        }

        @Override
        public ColumnFamilyStep row(CharSequence row) {
            return this.row(this.encodeCharSequence(row));
        }

        @Override
        public ColumnQualifierStep family(byte[] family, int offset, int length) {
            this.family = this.copyBytesIfNeeded(family, offset, length);
            this.familyOffset = this.copyBytes ? 0 : offset;
            this.familyLength = this.copyBytes ? this.family.length : length;
            return this;
        }

        @Override
        public ColumnQualifierStep family(byte[] family) {
            return this.family(family, 0, family.length);
        }

        @Override
        public ColumnQualifierStep family(Text family) {
            return this.family(family.getBytes(), 0, family.getLength());
        }

        @Override
        public ColumnQualifierStep family(CharSequence family) {
            return this.family(this.encodeCharSequence(family));
        }

        @Override
        public ColumnVisibilityStep qualifier(byte[] qualifier, int offset, int length) {
            this.qualifier = this.copyBytesIfNeeded(qualifier, offset, length);
            this.qualifierOffset = this.copyBytes ? 0 : offset;
            this.qualifierLength = this.copyBytes ? this.qualifier.length : length;
            return this;
        }

        @Override
        public ColumnVisibilityStep qualifier(byte[] qualifier) {
            return this.qualifier(qualifier, 0, qualifier.length);
        }

        @Override
        public ColumnVisibilityStep qualifier(Text qualifier) {
            return this.qualifier(qualifier.getBytes(), 0, qualifier.getLength());
        }

        @Override
        public ColumnVisibilityStep qualifier(CharSequence qualifier) {
            return this.qualifier(this.encodeCharSequence(qualifier));
        }

        @Override
        public Build visibility(byte[] visibility, int offset, int length) {
            this.visibility = this.copyBytesIfNeeded(visibility, offset, length);
            this.visibilityOffset = this.copyBytes ? 0 : offset;
            this.visibilityLength = this.copyBytes ? this.visibility.length : length;
            return this;
        }

        @Override
        public Build visibility(byte[] visibility) {
            return this.visibility(visibility, 0, visibility.length);
        }

        @Override
        public Build visibility(Text visibility) {
            return this.visibility(visibility.getBytes(), 0, visibility.getLength());
        }

        @Override
        public Build visibility(CharSequence visibility) {
            return this.visibility(this.encodeCharSequence(visibility));
        }

        @Override
        public Build visibility(ColumnVisibility visibility) {
            byte[] expr = visibility.getExpression();
            return this.visibility(expr, 0, expr.length);
        }

        @Override
        public final Build timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public Build deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        @Override
        public Key build() {
            return new Key(this.row, this.rowOffset, this.rowLength, this.family, this.familyOffset, this.familyLength, this.qualifier, this.qualifierOffset, this.qualifierLength, this.visibility, this.visibilityOffset, this.visibilityLength, this.timestamp, this.deleted, false);
        }
    }

    public static interface ColumnVisibilityStep
    extends Build {
        public Build visibility(byte[] var1);

        public Build visibility(byte[] var1, int var2, int var3);

        public Build visibility(Text var1);

        public Build visibility(CharSequence var1);

        public Build visibility(ColumnVisibility var1);
    }

    public static interface ColumnQualifierStep
    extends ColumnVisibilityStep {
        public ColumnVisibilityStep qualifier(byte[] var1);

        public ColumnVisibilityStep qualifier(byte[] var1, int var2, int var3);

        public ColumnVisibilityStep qualifier(Text var1);

        public ColumnVisibilityStep qualifier(CharSequence var1);
    }

    public static interface ColumnFamilyStep
    extends ColumnVisibilityStep {
        public ColumnQualifierStep family(byte[] var1);

        public ColumnQualifierStep family(byte[] var1, int var2, int var3);

        public ColumnQualifierStep family(Text var1);

        public ColumnQualifierStep family(CharSequence var1);
    }

    public static interface RowStep
    extends Build {
        public ColumnFamilyStep row(Text var1);

        public ColumnFamilyStep row(byte[] var1);

        public ColumnFamilyStep row(byte[] var1, int var2, int var3);

        public ColumnFamilyStep row(CharSequence var1);
    }

    public static interface Build {
        public Key build();

        public Build timestamp(long var1);

        public Build deleted(boolean var1);
    }
}

