/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.crypto;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Objects;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.commons.io.IOUtils;

public class CryptoUtils {
    public static SecureRandom newSha1SecureRandom() {
        return CryptoUtils.newSecureRandom("SHA1PRNG", "SUN");
    }

    private static SecureRandom newSecureRandom(String secureRNG, String secureRNGProvider) {
        SecureRandom secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance(secureRNG, secureRNGProvider);
            byte[] throwAway = new byte[16];
            secureRandom.nextBytes(throwAway);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new CryptoService.CryptoException("Unable to generate secure random.", e);
        }
        return secureRandom;
    }

    public static byte[] readParams(DataInputStream in) throws IOException {
        Objects.requireNonNull(in);
        int len = in.readInt();
        byte[] decryptionParams = new byte[len];
        IOUtils.readFully((InputStream)in, (byte[])decryptionParams);
        return decryptionParams;
    }

    public static void writeParams(byte[] decryptionParams, DataOutputStream out) throws IOException {
        Objects.requireNonNull(decryptionParams);
        Objects.requireNonNull(out);
        out.writeInt(decryptionParams.length);
        out.write(decryptionParams);
    }
}

