/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.crypto;

import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.cryptoImpl.NoCryptoService;
import org.apache.accumulo.core.spi.crypto.CryptoService;

public class CryptoServiceFactory {
    public static CryptoService newInstance(AccumuloConfiguration conf, ClassloaderType ct) {
        CryptoService newCryptoService;
        if (ct == ClassloaderType.ACCUMULO) {
            newCryptoService = Property.createInstanceFromPropertyName(conf, Property.INSTANCE_CRYPTO_SERVICE, CryptoService.class, new NoCryptoService());
        } else if (ct == ClassloaderType.JAVA) {
            String clazzName = conf.get(Property.INSTANCE_CRYPTO_SERVICE);
            if (clazzName == null || clazzName.trim().isEmpty()) {
                newCryptoService = new NoCryptoService();
            } else {
                try {
                    newCryptoService = CryptoServiceFactory.class.getClassLoader().loadClass(clazzName).asSubclass(CryptoService.class).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
        newCryptoService.init(conf.getAllPropertiesWithPrefix(Property.INSTANCE_CRYPTO_PREFIX));
        return newCryptoService;
    }

    public static CryptoService newDefaultInstance() {
        return CryptoServiceFactory.newInstance(DefaultConfiguration.getInstance(), ClassloaderType.JAVA);
    }

    public static enum ClassloaderType {
        ACCUMULO,
        JAVA;

    }
}

