/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.constraints;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.accumulo.core.constraints.Constraint;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.VisibilityEvaluator;
import org.apache.accumulo.core.security.VisibilityParseException;
import org.apache.accumulo.core.util.BadArgumentException;

public class VisibilityConstraint
implements Constraint {
    @Override
    public String getViolationDescription(short violationCode) {
        switch (violationCode) {
            case 1: {
                return "Malformed column visibility";
            }
            case 2: {
                return "User does not have authorization on column visibility";
            }
        }
        return null;
    }

    @Override
    public List<Short> check(Constraint.Environment env, Mutation mutation) {
        List<ColumnUpdate> updates = mutation.getUpdates();
        HashSet<String> ok = null;
        if (updates.size() > 1) {
            ok = new HashSet<String>();
        }
        VisibilityEvaluator ve = null;
        for (ColumnUpdate update2 : updates) {
            byte[] cv = update2.getColumnVisibility();
            if (cv.length <= 0) continue;
            String key = null;
            if (ok != null && ok.contains(key = new String(cv, StandardCharsets.UTF_8))) continue;
            try {
                if (ve == null) {
                    ve = new VisibilityEvaluator(env.getAuthorizationsContainer());
                }
                if (!ve.evaluate(new ColumnVisibility(cv))) {
                    return Collections.singletonList((short)2);
                }
            }
            catch (VisibilityParseException | BadArgumentException bae) {
                return Collections.singletonList((short)1);
            }
            if (ok == null) continue;
            ok.add(key);
        }
        return null;
    }
}

