/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigSanityCheck;
import org.apache.accumulo.core.conf.CredentialProviderFactoryShim;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteConfiguration
extends AccumuloConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SiteConfiguration.class);
    private static final AccumuloConfiguration parent = DefaultConfiguration.getInstance();
    private final ImmutableMap<String, String> config;

    public SiteConfiguration() {
        this(SiteConfiguration.getAccumuloPropsLocation());
    }

    public SiteConfiguration(Map<String, String> overrides) {
        this(SiteConfiguration.getAccumuloPropsLocation(), overrides);
    }

    public SiteConfiguration(File accumuloPropsFile) {
        this(accumuloPropsFile, Collections.emptyMap());
    }

    public SiteConfiguration(File accumuloPropsFile, Map<String, String> overrides) {
        this(SiteConfiguration.toURL(accumuloPropsFile), overrides);
    }

    public SiteConfiguration(URL accumuloPropsLocation) {
        this(accumuloPropsLocation, Collections.emptyMap());
    }

    public SiteConfiguration(URL accumuloPropsLocation, Map<String, String> overrides) {
        this.config = SiteConfiguration.createMap(accumuloPropsLocation, overrides);
        ConfigSanityCheck.validate((Iterable<Map.Entry<String, String>>)this.config.entrySet());
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="location of props is specified by an admin")
    private static ImmutableMap<String, String> createMap(URL accumuloPropsLocation, Map<String, String> overrides) {
        CompositeConfiguration config = new CompositeConfiguration();
        if (accumuloPropsLocation != null) {
            FileBasedConfigurationBuilder propsBuilder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().properties().setURL(accumuloPropsLocation)});
            try {
                config.addConfiguration((Configuration)propsBuilder.getConfiguration());
            }
            catch (ConfigurationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        config.getKeys().forEachRemaining(key -> result.put((String)key, config.getString(key)));
        overrides.forEach(result::put);
        String credProvider = (String)result.get(Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS.getKey());
        if (credProvider != null) {
            org.apache.hadoop.conf.Configuration hadoopConf = new org.apache.hadoop.conf.Configuration();
            hadoopConf.set("hadoop.security.credential.provider.path", credProvider);
            for (Property property : Property.values()) {
                char[] value;
                if (!property.isSensitive() || (value = CredentialProviderFactoryShim.getValueFromCredentialProvider(hadoopConf, property.getKey())) == null) continue;
                result.put(property.getKey(), new String(value));
            }
        }
        return ImmutableMap.copyOf(result);
    }

    private static URL toURL(File f) {
        try {
            return f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static URL getAccumuloPropsLocation() {
        URL siteUrl = SiteConfiguration.class.getClassLoader().getResource("accumulo-site.xml");
        if (siteUrl != null) {
            throw new IllegalArgumentException("Found deprecated config file 'accumulo-site.xml' on classpath. Since 2.0.0, this file was replaced by 'accumulo.properties'. Run the following command to convert an old 'accumulo-site.xml' file to the new format: accumulo convert-config -x /old/accumulo-site.xml -p /new/accumulo.properties");
        }
        String configFile = System.getProperty("accumulo.properties", "accumulo.properties");
        if (configFile.startsWith("file://")) {
            try {
                File f = new File(new URI(configFile));
                if (f.exists() && !f.isDirectory()) {
                    log.info("Found Accumulo configuration at {}", (Object)configFile);
                    return f.toURI().toURL();
                }
                throw new IllegalArgumentException("Failed to load Accumulo configuration at " + configFile);
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new IllegalArgumentException("Failed to load Accumulo configuration from " + configFile, e);
            }
        }
        URL accumuloConfigUrl = SiteConfiguration.class.getClassLoader().getResource(configFile);
        if (accumuloConfigUrl == null) {
            throw new IllegalArgumentException("Failed to load Accumulo configuration '" + configFile + "' from classpath");
        }
        log.info("Found Accumulo configuration on classpath at {}", (Object)accumuloConfigUrl.getFile());
        return accumuloConfigUrl;
    }

    @Override
    public String get(Property property) {
        String value = (String)this.config.get((Object)property.getKey());
        if (value == null || !property.getType().isValidFormat(value)) {
            if (value != null) {
                log.error("Using default value for {} due to improperly formatted {}: {}", new Object[]{property.getKey(), property.getType(), value});
            }
            value = parent.get(property);
        }
        return value;
    }

    @Override
    public boolean isPropertySet(Property prop, boolean cacheAndWatch) {
        return this.config.containsKey((Object)prop.getKey()) || parent.isPropertySet(prop, cacheAndWatch);
    }

    @Override
    public void getProperties(Map<String, String> props, Predicate<String> filter) {
        this.getProperties(props, filter, true);
    }

    public void getProperties(Map<String, String> props, Predicate<String> filter, boolean useDefaults) {
        if (useDefaults) {
            parent.getProperties(props, filter);
        }
        this.config.keySet().forEach(k -> {
            if (filter.test((String)k)) {
                props.put((String)k, (String)this.config.get(k));
            }
        });
    }
}

