/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.IterLoad;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.constraints.DefaultKeySizeConstraint;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IterConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(IterConfigUtil.class);
    public static final Comparator<IterInfo> ITER_INFO_COMPARATOR = Comparator.comparingInt(IterInfo::getPriority);

    public static Property getProperty(IteratorUtil.IteratorScope scope) {
        Objects.requireNonNull(scope);
        switch (scope) {
            case scan: {
                return Property.TABLE_ITERATOR_SCAN_PREFIX;
            }
            case minc: {
                return Property.TABLE_ITERATOR_MINC_PREFIX;
            }
            case majc: {
                return Property.TABLE_ITERATOR_MAJC_PREFIX;
            }
        }
        throw new IllegalStateException("Could not find configuration property for IteratorScope");
    }

    public static Map<String, String> generateInitialTableProperties(boolean limitVersion) {
        TreeMap<String, String> props = new TreeMap<String, String>();
        if (limitVersion) {
            for (IteratorUtil.IteratorScope iterScope : IteratorUtil.IteratorScope.values()) {
                props.put((Object)((Object)Property.TABLE_ITERATOR_PREFIX) + iterScope.name() + ".vers", "20," + VersioningIterator.class.getName());
                props.put((Object)((Object)Property.TABLE_ITERATOR_PREFIX) + iterScope.name() + ".vers.opt.maxVersions", "1");
            }
        }
        props.put((Object)((Object)Property.TABLE_CONSTRAINT_PREFIX) + "1", DefaultKeySizeConstraint.class.getName());
        return props;
    }

    public static List<IterInfo> parseIterConf(IteratorUtil.IteratorScope scope, List<IterInfo> iters, Map<String, Map<String, String>> allOptions, AccumuloConfiguration conf) {
        Map<String, String> properties = conf.getAllPropertiesWithPrefix(IterConfigUtil.getProperty(scope));
        ArrayList<IterInfo> iterators = new ArrayList<IterInfo>(iters);
        Property scopeProperty = IterConfigUtil.getProperty(scope);
        String scopePropertyKey = scopeProperty.getKey();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String suffix = entry.getKey().substring(scopePropertyKey.length());
            String[] suffixSplit = suffix.split("\\.", 3);
            if (suffixSplit.length == 1) {
                String[] sa = entry.getValue().split(",");
                int prio = Integer.parseInt(sa[0]);
                String className = sa[1];
                iterators.add(new IterInfo(prio, className, suffixSplit[0]));
                continue;
            }
            if (suffixSplit.length == 3 && suffixSplit[1].equals("opt")) {
                String iterName = suffixSplit[0];
                String optName = suffixSplit[2];
                Map<String, String> options = allOptions.get(iterName);
                if (options == null) {
                    options = new HashMap<String, String>();
                    allOptions.put(iterName, options);
                }
                options.put(optName, entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("Invalid iterator format: " + entry.getKey());
        }
        Collections.sort(iterators, ITER_INFO_COMPARATOR);
        return iterators;
    }

    public static void mergeIteratorConfig(List<IterInfo> destList, Map<String, Map<String, String>> destOpts, List<IterInfo> tableIters, Map<String, Map<String, String>> tableOpts, List<IterInfo> ssi, Map<String, Map<String, String>> ssio) {
        destList.addAll(tableIters);
        destList.addAll(ssi);
        Collections.sort(destList, ITER_INFO_COMPARATOR);
        Set<Map.Entry<String, Map<String, String>>> es = tableOpts.entrySet();
        for (Map.Entry<String, Map<String, String>> entry : es) {
            if (entry.getValue() == null) {
                destOpts.put(entry.getKey(), null);
                continue;
            }
            destOpts.put(entry.getKey(), new HashMap<String, String>(entry.getValue()));
        }
        IterConfigUtil.mergeOptions(ssio, destOpts);
    }

    private static void mergeOptions(Map<String, Map<String, String>> ssio, Map<String, Map<String, String>> allOptions) {
        ssio.forEach((k, v) -> {
            if (v != null) {
                Map options = (Map)allOptions.get(k);
                if (options == null) {
                    allOptions.put((String)k, (Map<String, String>)v);
                } else {
                    options.putAll(v);
                }
            }
        });
    }

    public static IterLoad loadIterConf(IteratorUtil.IteratorScope scope, List<IterInfo> iters, Map<String, Map<String, String>> iterOpts, AccumuloConfiguration conf) {
        HashMap<String, Map<String, String>> allOptions = new HashMap<String, Map<String, String>>();
        List<IterInfo> iterators = IterConfigUtil.parseIterConf(scope, iters, allOptions, conf);
        IterConfigUtil.mergeOptions(iterOpts, allOptions);
        return new IterLoad().iters(iterators).iterOpts(allOptions);
    }

    public static SortedKeyValueIterator<Key, Value> convertItersAndLoad(IteratorUtil.IteratorScope scope, SortedKeyValueIterator<Key, Value> source, AccumuloConfiguration conf, List<IteratorSetting> iterators, IteratorEnvironment env) throws IOException {
        ArrayList<IterInfo> ssiList = new ArrayList<IterInfo>();
        HashMap<String, Map<String, String>> ssio = new HashMap<String, Map<String, String>>();
        for (IteratorSetting is : iterators) {
            ssiList.add(new IterInfo(is.getPriority(), is.getIteratorClass(), is.getName()));
            ssio.put(is.getName(), is.getOptions());
        }
        IterLoad il = IterConfigUtil.loadIterConf(scope, ssiList, ssio, conf);
        il = il.iterEnv(env).useAccumuloClassLoader(true).context(conf.get(Property.TABLE_CLASSPATH));
        return IterConfigUtil.loadIterators(source, il);
    }

    public static SortedKeyValueIterator<Key, Value> loadIterators(SortedKeyValueIterator<Key, Value> source, IterLoad iterLoad) throws IOException {
        SortedKeyValueIterator<Key, Value> prev = source;
        try {
            for (IterInfo iterInfo : iterLoad.iters) {
                Class<SortedKeyValueIterator<Key, Value>> clazz = null;
                log.trace("Attempting to load iterator class {}", (Object)iterInfo.className);
                if (iterLoad.classCache != null) {
                    clazz = iterLoad.classCache.get(iterInfo.className);
                    if (clazz == null) {
                        clazz = IterConfigUtil.loadClass(iterLoad.useAccumuloClassLoader, iterLoad.context, iterInfo);
                        iterLoad.classCache.put(iterInfo.className, clazz);
                    }
                } else {
                    clazz = IterConfigUtil.loadClass(iterLoad.useAccumuloClassLoader, iterLoad.context, iterInfo);
                }
                SortedKeyValueIterator<Key, Value> skvi = clazz.newInstance();
                Map<String, String> options = iterLoad.iterOpts.get(iterInfo.iterName);
                if (options == null) {
                    options = Collections.emptyMap();
                }
                skvi.init(prev, options, iterLoad.iteratorEnvironment);
                prev = skvi;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.error(e.toString());
            throw new RuntimeException(e);
        }
        return prev;
    }

    private static Class<SortedKeyValueIterator<Key, Value>> loadClass(boolean useAccumuloClassLoader, String context, IterInfo iterInfo) throws ClassNotFoundException, IOException {
        Class clazz;
        if (useAccumuloClassLoader) {
            if (context != null && !context.equals("")) {
                clazz = AccumuloVFSClassLoader.getContextManager().loadClass(context, iterInfo.className, SortedKeyValueIterator.class);
                log.trace("Iterator class {} loaded from context {}, classloader: {}", new Object[]{iterInfo.className, context, clazz.getClassLoader()});
            } else {
                clazz = AccumuloVFSClassLoader.loadClass((String)iterInfo.className, SortedKeyValueIterator.class);
                log.trace("Iterator class {} loaded from AccumuloVFSClassLoader: {}", (Object)iterInfo.className, (Object)clazz.getClassLoader());
            }
        } else {
            clazz = Class.forName(iterInfo.className).asSubclass(SortedKeyValueIterator.class);
            log.trace("Iterator class {} loaded from classpath", (Object)iterInfo.className);
        }
        return clazz;
    }
}

