/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.TreeMap;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;

class ConfigurationDocGen {
    private PrintStream doc;
    private final TreeMap<String, Property> sortedProps = new TreeMap();

    void generate() {
        this.pageHeader();
        this.beginTable("Property");
        for (Property prop : this.sortedProps.values()) {
            if (prop.getType() == PropertyType.PREFIX) {
                this.prefixSection(prop);
                continue;
            }
            this.property(prop);
        }
        this.beginSection("Property Types");
        this.beginTable("Type");
        this.propertyTypeDescriptions();
        this.doc.close();
    }

    void beginSection(String section) {
        this.doc.println("\n### " + section + "\n");
    }

    void beginTable(String name) {
        this.doc.println("| " + name + " | Description |");
        this.doc.println("|--------------|-------------|");
    }

    void pageHeader() {
        this.doc.println("---");
        this.doc.println("title: Server Properties");
        this.doc.println("category: configuration");
        this.doc.println("order: 4");
        this.doc.println("---\n");
        this.doc.println("<!-- WARNING: Do not edit this file. It is a generated file that is copied from Accumulo build (from core/target/generated-docs) -->\n");
        this.doc.println("Below are properties set in `accumulo.properties` or the Accumulo shell that configure Accumulo servers (i.e tablet server, master, etc). Properties labeled 'Experimental' could be part of an incomplete feature or have a higher risk of changing in the future.\n");
    }

    void prefixSection(Property prefix) {
        boolean depr = prefix.isDeprecated();
        this.doc.print("| <a name=\"" + prefix.getKey().replace(".", "_") + "prefix\" class=\"prop\"></a> **" + prefix.getKey() + "*** | ");
        this.doc.print(prefix.isExperimental() ? "**Experimental.** " : "");
        this.doc.println((depr ? "**Deprecated.** " : "") + this.strike(this.sanitize(prefix.getDescription()), depr) + " |");
    }

    void property(Property prop) {
        boolean depr = prop.isDeprecated();
        this.doc.print("| <a name=\"" + prop.getKey().replace(".", "_") + "\" class=\"prop\"></a> " + prop.getKey() + " | ");
        this.doc.print(prop.isExperimental() ? "**Experimental.** " : "");
        this.doc.print((depr ? "**Deprecated.** " : "") + this.strike(this.sanitize(prop.getDescription()), depr) + "<br>");
        this.doc.print(this.strike("**type:** " + prop.getType().name(), depr) + ", ");
        this.doc.print(this.strike("**zk mutable:** " + this.isZooKeeperMutable(prop), depr) + ", ");
        String defaultValue = this.sanitize(prop.getDefaultValue()).trim();
        defaultValue = defaultValue.length() == 0 ? this.strike("**default value:** empty", depr) : (defaultValue.contains("\n") ? this.strike("**default value:** ", depr) + "\n```\n" + defaultValue + "\n```\n" : (prop.getType() == PropertyType.CLASSNAME && defaultValue.startsWith("org.apache.accumulo") ? this.strike("**default value:** {% jlink -f " + defaultValue + " %}", depr) : this.strike("**default value:** `" + defaultValue + "`", depr)));
        this.doc.println(defaultValue + " |");
    }

    private String strike(String s, boolean isDeprecated) {
        return (isDeprecated ? "~~" : "") + s + (isDeprecated ? "~~" : "");
    }

    void propertyTypeDescriptions() {
        for (PropertyType type : PropertyType.values()) {
            if (type == PropertyType.PREFIX) continue;
            this.doc.println("| " + this.sanitize(type.toString()) + " | " + this.sanitize(type.getFormatDescription()) + " |");
        }
    }

    String sanitize(String str) {
        return str.replace("\n", "<br>");
    }

    private ConfigurationDocGen(PrintStream doc) {
        this.doc = doc;
        for (Property prop : Property.values()) {
            this.sortedProps.put(prop.getKey(), prop);
        }
    }

    private String isZooKeeperMutable(Property prop) {
        if (!Property.isValidZooPropertyKey(prop.getKey())) {
            return "no";
        }
        if (Property.isFixedZooPropertyKey(prop)) {
            return "yes but requires restart of the " + prop.getKey().split("[.]")[0];
        }
        return "yes";
    }

    public static void main(String[] args) throws FileNotFoundException, UnsupportedEncodingException {
        if (args.length != 2 || !args[0].equals("--generate-markdown")) {
            throw new IllegalArgumentException("Usage: " + ConfigurationDocGen.class.getName() + " --generate-markdown <filename>");
        }
        new ConfigurationDocGen(new PrintStream(args[1], StandardCharsets.UTF_8.name())).generate();
    }
}

