/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl.mapreduce;

import java.math.BigInteger;
import org.apache.accumulo.core.client.mapreduce.InputTableConfig;
import org.apache.accumulo.core.client.mapreduce.RangeInputSplit;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Range;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Level;

@Deprecated
public class SplitUtils {
    public static void updateSplit(RangeInputSplit split, InputTableConfig tableConfig, Level logLevel) {
        split.setFetchedColumns(tableConfig.getFetchedColumns());
        split.setIterators(tableConfig.getIterators());
        split.setLogLevel(logLevel);
        split.setSamplerConfiguration(tableConfig.getSamplerConfiguration());
    }

    public static float getProgress(ByteSequence start, ByteSequence end, ByteSequence position) {
        int maxDepth = Math.min(Math.max(end.length(), start.length()), position.length());
        BigInteger startBI = new BigInteger(SplitUtils.extractBytes(start, maxDepth));
        BigInteger endBI = new BigInteger(SplitUtils.extractBytes(end, maxDepth));
        BigInteger positionBI = new BigInteger(SplitUtils.extractBytes(position, maxDepth));
        return (float)(positionBI.subtract(startBI).doubleValue() / endBI.subtract(startBI).doubleValue());
    }

    public static long getRangeLength(Range range) {
        Text startRow = range.isInfiniteStartKey() ? new Text(new byte[]{-128}) : range.getStartKey().getRow();
        Text stopRow = range.isInfiniteStopKey() ? new Text(new byte[]{127}) : range.getEndKey().getRow();
        int maxCommon = Math.min(7, Math.min(startRow.getLength(), stopRow.getLength()));
        long diff = 0L;
        byte[] start = startRow.getBytes();
        byte[] stop = stopRow.getBytes();
        for (int i = 0; i < maxCommon; ++i) {
            diff |= (long)(0xFF & (start[i] ^ stop[i]));
            diff <<= 8;
        }
        if (startRow.getLength() != stopRow.getLength()) {
            diff |= 0xFFL;
        }
        return diff + 1L;
    }

    static byte[] extractBytes(ByteSequence seq, int numBytes) {
        byte[] bytes = new byte[numBytes + 1];
        bytes[0] = 0;
        for (int i = 0; i < numBytes; ++i) {
            bytes[i + 1] = i >= seq.length() ? (byte)0 : seq.byteAt(i);
        }
        return bytes;
    }
}

