/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl.lexicoder;

import java.util.ArrayList;

public class ByteUtils {
    public static byte[] escape(byte[] in) {
        int escapeCount = 0;
        for (int i = 0; i < in.length; ++i) {
            if (in[i] != 0 && in[i] != 1) continue;
            ++escapeCount;
        }
        if (escapeCount == 0) {
            return in;
        }
        byte[] ret = new byte[escapeCount + in.length];
        int index = 0;
        block5: for (int i = 0; i < in.length; ++i) {
            switch (in[i]) {
                case 0: {
                    ret[index++] = 1;
                    ret[index++] = 1;
                    continue block5;
                }
                case 1: {
                    ret[index++] = 1;
                    ret[index++] = 2;
                    continue block5;
                }
                default: {
                    ret[index++] = in[i];
                }
            }
        }
        return ret;
    }

    public static byte[] unescape(byte[] in) {
        int escapeCount = 0;
        for (int i = 0; i < in.length; ++i) {
            if (in[i] != 1) continue;
            ++escapeCount;
            ++i;
        }
        if (escapeCount == 0) {
            return in;
        }
        byte[] ret = new byte[in.length - escapeCount];
        int index = 0;
        for (int i = 0; i < in.length; ++i) {
            if (in[i] == 1) {
                if (++i >= in.length) {
                    throw new IllegalArgumentException("Bad bytes when attempting to unescape. Expected more bytes after last byte " + String.format("x%02x", in[in.length - 1]));
                }
                ret[index++] = (byte)(in[i] - 1);
                continue;
            }
            ret[index++] = in[i];
        }
        return ret;
    }

    public static byte[][] split(byte[] data) {
        return ByteUtils.split(data, 0, data.length);
    }

    public static byte[][] split(byte[] data, int dataOffset, int len) {
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        for (int i = dataOffset; i < dataOffset + len; ++i) {
            if (data[i] != 0) continue;
            offsets.add(i);
        }
        offsets.add(dataOffset + len);
        byte[][] ret = new byte[offsets.size()][];
        int index = dataOffset;
        for (int i = 0; i < offsets.size(); ++i) {
            ret[i] = new byte[(Integer)offsets.get(i) - index];
            System.arraycopy(data, index, ret[i], 0, ret[i].length);
            index = (Integer)offsets.get(i) + 1;
        }
        return ret;
    }

    public static byte[] concat(byte[] ... fields) {
        int len = 0;
        for (byte[] field : fields) {
            len += field.length;
        }
        byte[] ret = new byte[len + fields.length - 1];
        int index = 0;
        for (byte[] field : fields) {
            System.arraycopy(field, 0, ret, index, field.length);
            if ((index += field.length) >= ret.length) continue;
            ret[index++] = 0;
        }
        return ret;
    }
}

