/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl.bulk;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Stream;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.bulk.BulkImport;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;

class ConcurrentKeyExtentCache
implements BulkImport.KeyExtentCache {
    private static final Text MAX = new Text();
    private Set<Text> rowsToLookup = Collections.synchronizedSet(new HashSet());
    List<Text> lookupRows = new ArrayList<Text>();
    private ConcurrentSkipListMap<Text, KeyExtent> extents = new ConcurrentSkipListMap((t1, t2) -> t1 == t2 ? 0 : (t1 == MAX ? 1 : (t2 == MAX ? -1 : t1.compareTo((BinaryComparable)t2))));
    private TableId tableId;
    private ClientContext ctx;

    ConcurrentKeyExtentCache(TableId tableId, ClientContext ctx) {
        this.tableId = tableId;
        this.ctx = ctx;
    }

    private KeyExtent getFromCache(Text row) {
        Map.Entry<Text, KeyExtent> entry = this.extents.ceilingEntry(row);
        if (entry != null && entry.getValue().contains((BinaryComparable)row)) {
            return entry.getValue();
        }
        return null;
    }

    private boolean inCache(KeyExtent e) {
        return Objects.equals(e, this.extents.get(e.getEndRow() == null ? MAX : e.getEndRow()));
    }

    @VisibleForTesting
    protected void updateCache(KeyExtent e) {
        Text prevRow = e.getPrevEndRow() == null ? new Text() : e.getPrevEndRow();
        Text endRow = e.getEndRow() == null ? MAX : e.getEndRow();
        this.extents.subMap((Object)prevRow, e.getPrevEndRow() == null, (Object)endRow, true).clear();
        this.extents.put(endRow, e);
    }

    @VisibleForTesting
    protected Stream<KeyExtent> lookupExtents(Text row) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        return TabletsMetadata.builder().forTable(this.tableId).overlapping(row, null).checkConsistency().fetchPrev().build(this.ctx).stream().limit(100L).map(TabletMetadata::getExtent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyExtent lookup(Text row) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        KeyExtent ke;
        while ((ke = this.getFromCache(row)) == null) {
            this.rowsToLookup.add(row);
            ConcurrentKeyExtentCache concurrentKeyExtentCache = this;
            synchronized (concurrentKeyExtentCache) {
                ke = this.getFromCache(row);
                if (ke != null) {
                    this.rowsToLookup.remove(row);
                    return ke;
                }
                this.lookupRows.clear();
                Set<Text> set = this.rowsToLookup;
                synchronized (set) {
                    this.rowsToLookup.forEach(this.lookupRows::add);
                    this.rowsToLookup.clear();
                }
                this.lookupRows.sort(BinaryComparable::compareTo);
                for (Text lookupRow : this.lookupRows) {
                    KeyExtent ke2;
                    if (this.getFromCache(lookupRow) != null) continue;
                    Iterator iter = this.lookupExtents(lookupRow).iterator();
                    while (iter.hasNext() && !this.inCache(ke2 = (KeyExtent)iter.next())) {
                        this.updateCache(ke2);
                    }
                }
            }
        }
        return ke;
    }
}

