/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.TabletLocator;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.tabletserver.thrift.TDurability;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Writer {
    private static final Logger log = LoggerFactory.getLogger(Writer.class);
    private ClientContext context;
    private TableId tableId;

    public Writer(ClientContext context, TableId tableId) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        Preconditions.checkArgument((tableId != null ? 1 : 0) != 0, (Object)"tableId is null");
        this.context = context;
        this.tableId = tableId;
    }

    private static void updateServer(ClientContext context, Mutation m, KeyExtent extent, HostAndPort server) throws TException, NotServingTabletException, ConstraintViolationException, AccumuloSecurityException {
        Preconditions.checkArgument((m != null ? 1 : 0) != 0, (Object)"m is null");
        Preconditions.checkArgument((extent != null ? 1 : 0) != 0, (Object)"extent is null");
        Preconditions.checkArgument((server != null ? 1 : 0) != 0, (Object)"server is null");
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        TabletClientService.Client client = null;
        try {
            client = ThriftUtil.getTServerClient(server, context);
            client.update(TraceUtil.traceInfo(), context.rpcCreds(), extent.toThrift(), m.toThrift(), TDurability.DEFAULT);
            return;
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code);
        }
        finally {
            ThriftUtil.returnClient(client);
        }
    }

    public void update(Mutation m) throws AccumuloException, AccumuloSecurityException, ConstraintViolationException, TableNotFoundException {
        Preconditions.checkArgument((m != null ? 1 : 0) != 0, (Object)"m is null");
        if (m.size() == 0) {
            throw new IllegalArgumentException("Can not add empty mutations");
        }
        while (true) {
            TabletLocator.TabletLocation tabLoc;
            if ((tabLoc = TabletLocator.getLocator(this.context, this.tableId).locateTablet(this.context, new Text(m.getRow()), false, true)) == null) {
                log.trace("No tablet location found for row {}", (Object)new String(m.getRow(), StandardCharsets.UTF_8));
                UtilWaitThread.sleepUninterruptibly(500L, TimeUnit.MILLISECONDS);
                continue;
            }
            HostAndPort parsedLocation = HostAndPort.fromString(tabLoc.tablet_location);
            try {
                Writer.updateServer(this.context, m, tabLoc.tablet_extent, parsedLocation);
                return;
            }
            catch (NotServingTabletException e) {
                log.trace("Not serving tablet, server = {}", (Object)parsedLocation);
                TabletLocator.getLocator(this.context, this.tableId).invalidateCache(tabLoc.tablet_extent);
            }
            catch (ConstraintViolationException cve) {
                log.error("error sending update to {}", (Object)parsedLocation, (Object)cve);
                TabletLocator.getLocator(this.context, this.tableId).invalidateCache(tabLoc.tablet_extent);
                throw cve;
            }
            catch (TException e) {
                log.error("error sending update to {}", (Object)parsedLocation, (Object)e);
                TabletLocator.getLocator(this.context, this.tableId).invalidateCache(tabLoc.tablet_extent);
            }
            UtilWaitThread.sleepUninterruptibly(500L, TimeUnit.MILLISECONDS);
        }
    }
}

