/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.clientImpl.AccumuloServerException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.IsolationException;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.clientImpl.TabletLocator;
import org.apache.accumulo.core.clientImpl.TabletType;
import org.apache.accumulo.core.clientImpl.Translator;
import org.apache.accumulo.core.clientImpl.Translators;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyValue;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.InitialScan;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.dataImpl.thrift.ScanResult;
import org.apache.accumulo.core.dataImpl.thrift.TKeyValue;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.tabletserver.thrift.NoSuchScanIDException;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.tabletserver.thrift.TSampleNotPresentException;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.tabletserver.thrift.TooManyFilesException;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.hadoop.io.Text;
import org.apache.htrace.Trace;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftScanner {
    private static final Logger log = LoggerFactory.getLogger(ThriftScanner.class);
    public static final Map<TabletType, Set<String>> serversWaitedForWrites = new EnumMap<TabletType, Set<String>>(TabletType.class);
    private static Random secureRandom = new SecureRandom();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getBatchFromServer(ClientContext context, Range range, KeyExtent extent, String server, SortedMap<Key, Value> results, SortedSet<Column> fetchedColumns, List<IterInfo> serverSideIteratorList, Map<String, Map<String, String>> serverSideIteratorOptions, int size, Authorizations authorizations, long batchTimeOut, String classLoaderContext) throws AccumuloException, AccumuloSecurityException {
        block11: {
            boolean bl;
            if (server == null) {
                throw new AccumuloException(new IOException());
            }
            HostAndPort parsedServer = HostAndPort.fromString(server);
            TInfo tinfo = TraceUtil.traceInfo();
            TabletClientService.Client client = ThriftUtil.getTServerClient(parsedServer, context);
            try {
                ScanState scanState = new ScanState(context, extent.getTableId(), authorizations, range, fetchedColumns, size, serverSideIteratorList, serverSideIteratorOptions, false, 3L, null, batchTimeOut, classLoaderContext, null);
                TabletType ttype = TabletType.type(extent);
                boolean waitForWrites = !serversWaitedForWrites.get((Object)ttype).contains(server);
                InitialScan isr = client.startScan(tinfo, scanState.context.rpcCreds(), extent.toThrift(), scanState.range.toThrift(), Translator.translate(scanState.columns, Translators.CT), scanState.size, scanState.serverSideIteratorList, scanState.serverSideIteratorOptions, scanState.authorizations.getAuthorizationsBB(), waitForWrites, scanState.isolated, scanState.readaheadThreshold, null, scanState.batchTimeOut, classLoaderContext, scanState.executionHints);
                if (waitForWrites) {
                    serversWaitedForWrites.get((Object)ttype).add(server);
                }
                Key.decompress(isr.result.results);
                for (TKeyValue kv : isr.result.results) {
                    results.put(new Key(kv.key), new Value(kv.value));
                }
                client.closeScan(tinfo, isr.scanID);
                bl = isr.result.more;
            }
            catch (Throwable throwable) {
                try {
                    ThriftUtil.returnClient(client);
                    throw throwable;
                }
                catch (TApplicationException tae) {
                    throw new AccumuloServerException(server, tae);
                }
                catch (TooManyFilesException e) {
                    log.debug("Tablet ({}) has too many files {} : {}", new Object[]{extent, server, e.getMessage()});
                    break block11;
                }
                catch (ThriftSecurityException e) {
                    log.warn("Security Violation in scan request to {}: {}", (Object)server, (Object)e.getMessage());
                    throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
                }
                catch (TException e) {
                    log.debug("Error getting transport to {}: {}", (Object)server, (Object)e.getMessage());
                }
            }
            ThriftUtil.returnClient(client);
            return bl;
        }
        throw new AccumuloException("getBatchFromServer: failed");
    }

    static long pause(long millis, long maxSleep) throws InterruptedException {
        Thread.sleep(millis);
        return (long)((double)Math.min(millis * 2L, maxSleep) * (0.9 + secureRandom.nextDouble() / 5.0));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<KeyValue> scan(ClientContext context, ScanState scanState, long timeOut) throws ScanTimedOutException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        loc = null;
        startTime = System.currentTimeMillis();
        lastError = null;
        error = null;
        tooManyFilesCount = 0;
        sleepMillis = 100L;
        maxSleepTime = context.getConfiguration().getTimeInMillis(Property.GENERAL_MAX_SCANNER_RETRY_PERIOD);
        results = null;
        try {
            block66: {
                span = Trace.startSpan((String)"scan");
lbl12:
                // 8 sources

                while (true) {
                    if (results == null && !scanState.finished) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new AccumuloException("Thread interrupted");
                        }
                        if ((double)(System.currentTimeMillis() - startTime) / 1000.0 > (double)timeOut) {
                            throw new ScanTimedOutException();
                        }
                        break block66;
                    }
                    if (results != null && results.size() == 0 && scanState.finished) {
                        results = null;
                    }
                    var16_13 = results;
                    return var16_13;
                }
                finally {
                    if (span != null) {
                        span.close();
                    }
                }
            }
            while (loc == null) {
                currentTime = System.currentTimeMillis();
                if ((double)(currentTime - startTime) / 1000.0 > (double)timeOut) {
                    throw new ScanTimedOutException();
                }
                try {
                    locateSpan = Trace.startSpan((String)"scan:locateTablet");
                    try {
                        loc = TabletLocator.getLocator(context, scanState.tableId).locateTablet(context, scanState.startRow, scanState.skipStartRow, false);
                        if (loc == null) {
                            if (!Tables.exists(context, scanState.tableId)) {
                                throw new TableDeletedException(scanState.tableId.canonical());
                            }
                            if (Tables.getTableState(context, scanState.tableId) == TableState.OFFLINE) {
                                throw new TableOfflineException(Tables.getTableOfflineMsg(context, scanState.tableId));
                            }
                            error = "Failed to locate tablet for table : " + scanState.tableId + " row : " + scanState.startRow;
                            if (!error.equals(lastError)) {
                                ThriftScanner.log.debug("{}", (Object)error);
                            } else if (ThriftScanner.log.isTraceEnabled()) {
                                ThriftScanner.log.trace("{}", (Object)error);
                            }
                            lastError = error;
                            sleepMillis = ThriftScanner.pause(sleepMillis, maxSleepTime);
                            continue;
                        }
                        dataRange = loc.tablet_extent.toDataRange();
                        if (scanState.range.getStartKey() != null && dataRange.afterEndKey(scanState.range.getStartKey())) {
                            scanState.startRow = loc.tablet_extent.getEndRow();
                            scanState.skipStartRow = true;
                            loc = null;
                            continue;
                        }
                        if (scanState.range.getEndKey() == null || !dataRange.beforeStartKey(scanState.range.getEndKey())) continue;
                        throw new RuntimeException("Unexpected tablet, extent : " + loc.tablet_extent + "  range : " + scanState.range + " startRow : " + scanState.startRow);
                    }
                    finally {
                        if (locateSpan == null) continue;
                        locateSpan.close();
                    }
                }
                catch (AccumuloServerException e) {
                    ThriftScanner.log.debug("Scan failed, server side exception : {}", (Object)e.getMessage());
                    throw e;
                }
                catch (AccumuloException e) {
                    error = "exception from tablet loc " + e.getMessage();
                    if (!error.equals(lastError)) {
                        ThriftScanner.log.debug("{}", (Object)error);
                    } else if (ThriftScanner.log.isTraceEnabled()) {
                        ThriftScanner.log.trace("{}", (Object)error);
                    }
                    lastError = error;
                    sleepMillis = ThriftScanner.pause(sleepMillis, maxSleepTime);
                }
            }
            try {
                scanLocation = Trace.startSpan((String)"scan:location");
                try {
                    if (scanLocation.getSpan() != null) {
                        scanLocation.getSpan().addKVAnnotation("tserver", loc.tablet_location);
                    }
                    results = ThriftScanner.scan(loc, scanState, context);
                }
                finally {
                    if (scanLocation == null) ** GOTO lbl12
                    scanLocation.close();
                }
            }
            catch (AccumuloSecurityException e) {
                Tables.clearCache(context);
                if (!Tables.exists(context, scanState.tableId)) {
                    throw new TableDeletedException(scanState.tableId.canonical());
                }
                e.setTableInfo(Tables.getPrintableTableInfoFromId(context, scanState.tableId));
                throw e;
            }
            catch (TApplicationException tae) {
                throw new AccumuloServerException(loc.tablet_location, tae);
            }
            catch (TSampleNotPresentException tsnpe) {
                message = "Table " + Tables.getPrintableTableInfoFromId(context, scanState.tableId) + " does not have sampling configured or built";
                throw new SampleNotPresentException(message, (Exception)tsnpe);
            }
            catch (NotServingTabletException e) {
                error = "Scan failed, not serving tablet " + loc;
                if (!error.equals(lastError)) {
                    ThriftScanner.log.debug("{}", (Object)error);
                } else if (ThriftScanner.log.isTraceEnabled()) {
                    ThriftScanner.log.trace("{}", (Object)error);
                }
                lastError = error;
                TabletLocator.getLocator(context, scanState.tableId).invalidateCache(loc.tablet_extent);
                loc = null;
                scanState.scanID = null;
                if (scanState.isolated) {
                    throw new IsolationException();
                }
                sleepMillis = ThriftScanner.pause(sleepMillis, maxSleepTime);
            }
            catch (NoSuchScanIDException e) {
                error = "Scan failed, no such scan id " + scanState.scanID + " " + loc;
                if (!error.equals(lastError)) {
                    ThriftScanner.log.debug("{}", (Object)error);
                } else if (ThriftScanner.log.isTraceEnabled()) {
                    ThriftScanner.log.trace("{}", (Object)error);
                }
                lastError = error;
                if (scanState.isolated) {
                    throw new IsolationException();
                }
                scanState.scanID = null;
            }
            catch (TooManyFilesException e) {
                error = "Tablet has too many files " + loc + " retrying...";
                if (!error.equals(lastError)) {
                    ThriftScanner.log.debug("{}", (Object)error);
                    tooManyFilesCount = 0;
                } else if (++tooManyFilesCount == 300) {
                    ThriftScanner.log.warn("{}", (Object)error);
                } else if (ThriftScanner.log.isTraceEnabled()) {
                    ThriftScanner.log.trace("{}", (Object)error);
                }
                lastError = error;
                scanState.scanID = null;
                if (scanState.isolated) {
                    throw new IsolationException();
                }
                sleepMillis = ThriftScanner.pause(sleepMillis, maxSleepTime);
            }
            catch (TException e) {
                TabletLocator.getLocator(context, scanState.tableId).invalidateCache(context, loc.tablet_location);
                error = "Scan failed, thrift error " + e.getClass().getName() + "  " + e.getMessage() + " " + loc;
                if (!error.equals(lastError)) {
                    ThriftScanner.log.debug("{}", (Object)error);
                } else if (ThriftScanner.log.isTraceEnabled()) {
                    ThriftScanner.log.trace("{}", (Object)error);
                }
                lastError = error;
                loc = null;
                scanState.scanID = null;
                if (scanState.isolated) {
                    throw new IsolationException();
                }
                sleepMillis = ThriftScanner.pause(sleepMillis, maxSleepTime);
                ** continue;
            }
        }
        catch (InterruptedException ex) {
            throw new AccumuloException(ex);
        }
lbl158:
        // 1 sources

        ** GOTO lbl-1000
    }

    private static List<KeyValue> scan(TabletLocator.TabletLocation loc, ScanState scanState, ClientContext context) throws AccumuloSecurityException, NotServingTabletException, TException, NoSuchScanIDException, TooManyFilesException, TSampleNotPresentException {
        if (scanState.finished) {
            return null;
        }
        OpTimer timer = null;
        TInfo tinfo = TraceUtil.traceInfo();
        HostAndPort parsedLocation = HostAndPort.fromString(loc.tablet_location);
        TabletClientService.Client client = ThriftUtil.getTServerClient(parsedLocation, context);
        String old = Thread.currentThread().getName();
        try {
            ScanResult sr;
            String msg;
            if (scanState.prevLoc != null && !scanState.prevLoc.equals(loc)) {
                scanState.scanID = null;
            }
            scanState.prevLoc = loc;
            if (scanState.scanID == null) {
                TabletType ttype;
                Thread.currentThread().setName("Starting scan tserver=" + loc.tablet_location + " tableId=" + loc.tablet_extent.getTableId());
                if (log.isTraceEnabled()) {
                    msg = "Starting scan tserver=" + loc.tablet_location + " tablet=" + loc.tablet_extent + " range=" + scanState.range + " ssil=" + scanState.serverSideIteratorList + " ssio=" + scanState.serverSideIteratorOptions + " context=" + scanState.classLoaderContext;
                    log.trace("tid={} {}", (Object)Thread.currentThread().getId(), (Object)msg);
                    timer = new OpTimer().start();
                }
                boolean waitForWrites = !serversWaitedForWrites.get((Object)(ttype = TabletType.type(loc.tablet_extent))).contains(loc.tablet_location);
                InitialScan is = client.startScan(tinfo, scanState.context.rpcCreds(), loc.tablet_extent.toThrift(), scanState.range.toThrift(), Translator.translate(scanState.columns, Translators.CT), scanState.size, scanState.serverSideIteratorList, scanState.serverSideIteratorOptions, scanState.authorizations.getAuthorizationsBB(), waitForWrites, scanState.isolated, scanState.readaheadThreshold, SamplerConfigurationImpl.toThrift(scanState.samplerConfig), scanState.batchTimeOut, scanState.classLoaderContext, scanState.executionHints);
                if (waitForWrites) {
                    serversWaitedForWrites.get((Object)ttype).add(loc.tablet_location);
                }
                sr = is.result;
                if (sr.more) {
                    scanState.scanID = is.scanID;
                } else {
                    client.closeScan(tinfo, is.scanID);
                }
            } else {
                msg = "Continuing scan tserver=" + loc.tablet_location + " scanid=" + scanState.scanID;
                Thread.currentThread().setName(msg);
                if (log.isTraceEnabled()) {
                    log.trace("tid={} {}", (Object)Thread.currentThread().getId(), (Object)msg);
                    timer = new OpTimer().start();
                }
                sr = client.continueScan(tinfo, scanState.scanID);
                if (!sr.more) {
                    client.closeScan(tinfo, scanState.scanID);
                    scanState.scanID = null;
                }
            }
            if (!sr.more) {
                if (loc.tablet_extent.getEndRow() == null) {
                    scanState.finished = true;
                    if (timer != null) {
                        timer.stop();
                        log.trace("tid={} Completely finished scan in {} #results={}", new Object[]{Thread.currentThread().getId(), String.format("%.3f secs", timer.scale(TimeUnit.SECONDS)), sr.results.size()});
                    }
                } else if (scanState.range.getEndKey() == null || !scanState.range.afterEndKey(new Key(loc.tablet_extent.getEndRow()).followingKey(PartialKey.ROW))) {
                    scanState.startRow = loc.tablet_extent.getEndRow();
                    scanState.skipStartRow = true;
                    if (timer != null) {
                        timer.stop();
                        log.trace("tid={} Finished scanning tablet in {} #results={}", new Object[]{Thread.currentThread().getId(), String.format("%.3f secs", timer.scale(TimeUnit.SECONDS)), sr.results.size()});
                    }
                } else {
                    scanState.finished = true;
                    if (timer != null) {
                        timer.stop();
                        log.trace("tid={} Completely finished in {} #results={}", new Object[]{Thread.currentThread().getId(), String.format("%.3f secs", timer.scale(TimeUnit.SECONDS)), sr.results.size()});
                    }
                }
            } else if (timer != null) {
                timer.stop();
                log.trace("tid={} Finished scan in {} #results={} scanid={}", new Object[]{Thread.currentThread().getId(), String.format("%.3f secs", timer.scale(TimeUnit.SECONDS)), sr.results.size(), scanState.scanID});
            }
            Key.decompress(sr.results);
            if (sr.results.size() > 0 && !scanState.finished) {
                scanState.range = new Range(new Key(sr.results.get((int)(sr.results.size() - 1)).key), false, scanState.range.getEndKey(), scanState.range.isEndKeyInclusive());
            }
            ArrayList<KeyValue> results = new ArrayList<KeyValue>(sr.results.size());
            for (TKeyValue tkv : sr.results) {
                results.add(new KeyValue(new Key(tkv.key), tkv.value));
            }
            ArrayList<KeyValue> arrayList = results;
            return arrayList;
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        finally {
            ThriftUtil.returnClient(client);
            Thread.currentThread().setName(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void close(ScanState scanState) {
        if (!scanState.finished && scanState.scanID != null && scanState.prevLoc != null) {
            TInfo tinfo = TraceUtil.traceInfo();
            log.debug("Closing active scan {} {}", (Object)scanState.prevLoc, (Object)scanState.scanID);
            HostAndPort parsedLocation = HostAndPort.fromString(scanState.prevLoc.tablet_location);
            TabletClientService.Client client = null;
            try {
                client = ThriftUtil.getTServerClient(parsedLocation, scanState.context);
                client.closeScan(tinfo, scanState.scanID);
            }
            catch (TException e) {
                log.debug("Failed to close active scan " + scanState.prevLoc + " " + scanState.scanID, (Throwable)e);
            }
            finally {
                if (client != null) {
                    ThriftUtil.returnClient(client);
                }
            }
        }
    }

    static {
        for (TabletType ttype : TabletType.values()) {
            serversWaitedForWrites.put(ttype, Collections.synchronizedSet(new HashSet()));
        }
    }

    public static class ScanTimedOutException
    extends IOException {
        private static final long serialVersionUID = 1L;
    }

    public static class ScanState {
        boolean isolated;
        TableId tableId;
        Text startRow;
        boolean skipStartRow;
        long readaheadThreshold;
        long batchTimeOut;
        Range range;
        int size;
        ClientContext context;
        Authorizations authorizations;
        List<Column> columns;
        TabletLocator.TabletLocation prevLoc;
        Long scanID;
        String classLoaderContext;
        boolean finished = false;
        List<IterInfo> serverSideIteratorList;
        Map<String, Map<String, String>> serverSideIteratorOptions;
        SamplerConfiguration samplerConfig;
        Map<String, String> executionHints;

        public ScanState(ClientContext context, TableId tableId, Authorizations authorizations, Range range, SortedSet<Column> fetchedColumns, int size, List<IterInfo> serverSideIteratorList, Map<String, Map<String, String>> serverSideIteratorOptions, boolean isolated, long readaheadThreshold, SamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext, Map<String, String> executionHints) {
            this.context = context;
            this.authorizations = authorizations;
            this.classLoaderContext = classLoaderContext;
            this.columns = new ArrayList<Column>(fetchedColumns.size());
            for (Column column : fetchedColumns) {
                this.columns.add(column);
            }
            this.tableId = tableId;
            this.range = range;
            Key startKey = range.getStartKey();
            if (startKey == null) {
                startKey = new Key();
            }
            this.startRow = startKey.getRow();
            this.skipStartRow = false;
            this.size = size;
            this.serverSideIteratorList = serverSideIteratorList;
            this.serverSideIteratorOptions = serverSideIteratorOptions;
            this.isolated = isolated;
            this.readaheadThreshold = readaheadThreshold;
            this.samplerConfig = samplerConfig;
            this.batchTimeOut = batchTimeOut;
            this.executionHints = executionHints == null || executionHints.size() == 0 ? null : executionHints;
        }
    }
}

