/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.RootTabletLocator;
import org.apache.accumulo.core.clientImpl.TabletLocatorImpl;
import org.apache.accumulo.core.clientImpl.ZookeeperLockChecker;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataLocationObtainer;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.core.singletons.SingletonService;
import org.apache.hadoop.io.Text;

public abstract class TabletLocator {
    private volatile boolean isValid = true;
    private static HashMap<LocatorKey, TabletLocator> locators = new HashMap();
    private static boolean enabled = true;

    boolean isValid() {
        return this.isValid;
    }

    public abstract TabletLocation locateTablet(ClientContext var1, Text var2, boolean var3, boolean var4) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public abstract <T extends Mutation> void binMutations(ClientContext var1, List<T> var2, Map<String, TabletServerMutations<T>> var3, List<T> var4) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public abstract List<Range> binRanges(ClientContext var1, List<Range> var2, Map<String, Map<KeyExtent, List<Range>>> var3) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;

    public abstract void invalidateCache(KeyExtent var1);

    public abstract void invalidateCache(Collection<KeyExtent> var1);

    public abstract void invalidateCache();

    public abstract void invalidateCache(ClientContext var1, String var2);

    public static synchronized void clearLocators() {
        for (TabletLocator locator : locators.values()) {
            locator.isValid = false;
        }
        locators.clear();
    }

    static synchronized boolean isEnabled() {
        return enabled;
    }

    static synchronized void disable() {
        TabletLocator.clearLocators();
        enabled = false;
    }

    static synchronized void enable() {
        enabled = true;
    }

    public static synchronized TabletLocator getLocator(ClientContext context, TableId tableId) {
        Preconditions.checkState((boolean)enabled, (Object)"The Accumulo singleton that that tracks tablet locations is disabled. This is likely caused by all AccumuloClients being closed or garbage collected.");
        LocatorKey key = new LocatorKey(context.getInstanceID(), tableId);
        TabletLocator tl = locators.get(key);
        if (tl == null) {
            MetadataLocationObtainer mlo = new MetadataLocationObtainer();
            tl = RootTable.ID.equals(tableId) ? new RootTabletLocator(new ZookeeperLockChecker(context)) : (MetadataTable.ID.equals(tableId) ? new TabletLocatorImpl(MetadataTable.ID, TabletLocator.getLocator(context, RootTable.ID), mlo, new ZookeeperLockChecker(context)) : new TabletLocatorImpl(tableId, TabletLocator.getLocator(context, MetadataTable.ID), mlo, new ZookeeperLockChecker(context)));
            locators.put(key, tl);
        }
        return tl;
    }

    static {
        SingletonManager.register(new SingletonService(){

            @Override
            public boolean isEnabled() {
                return TabletLocator.isEnabled();
            }

            @Override
            public void enable() {
                TabletLocator.enable();
            }

            @Override
            public void disable() {
                TabletLocator.disable();
            }
        });
    }

    public static class TabletServerMutations<T extends Mutation> {
        private Map<KeyExtent, List<T>> mutations;
        private String tserverSession;

        public TabletServerMutations(String tserverSession) {
            this.tserverSession = tserverSession;
            this.mutations = new HashMap<KeyExtent, List<T>>();
        }

        public void addMutation(KeyExtent ke, T m) {
            List mutList = this.mutations.computeIfAbsent(ke, k -> new ArrayList());
            mutList.add(m);
        }

        public Map<KeyExtent, List<T>> getMutations() {
            return this.mutations;
        }

        final String getSession() {
            return this.tserverSession;
        }
    }

    public static class TabletLocation
    implements Comparable<TabletLocation> {
        private static final WeakHashMap<String, WeakReference<String>> tabletLocs = new WeakHashMap();
        public final KeyExtent tablet_extent;
        public final String tablet_location;
        public final String tablet_session;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String dedupeLocation(String tabletLoc) {
            WeakHashMap<String, WeakReference<String>> weakHashMap = tabletLocs;
            synchronized (weakHashMap) {
                String loc;
                WeakReference<String> lref = tabletLocs.get(tabletLoc);
                if (lref != null && (loc = (String)lref.get()) != null) {
                    return loc;
                }
                tabletLocs.put(tabletLoc, new WeakReference<String>(tabletLoc));
                return tabletLoc;
            }
        }

        public TabletLocation(KeyExtent tablet_extent, String tablet_location, String session) {
            Preconditions.checkArgument((tablet_extent != null ? 1 : 0) != 0, (Object)"tablet_extent is null");
            Preconditions.checkArgument((tablet_location != null ? 1 : 0) != 0, (Object)"tablet_location is null");
            Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"session is null");
            this.tablet_extent = tablet_extent;
            this.tablet_location = TabletLocation.dedupeLocation(tablet_location);
            this.tablet_session = TabletLocation.dedupeLocation(session);
        }

        public boolean equals(Object o) {
            if (o instanceof TabletLocation) {
                TabletLocation otl = (TabletLocation)o;
                return this.tablet_extent.equals(otl.tablet_extent) && this.tablet_location.equals(otl.tablet_location) && this.tablet_session.equals(otl.tablet_session);
            }
            return false;
        }

        public int hashCode() {
            throw new UnsupportedOperationException("hashcode is not implemented for class " + this.getClass());
        }

        public String toString() {
            return "(" + this.tablet_extent + "," + this.tablet_location + "," + this.tablet_session + ")";
        }

        @Override
        public int compareTo(TabletLocation o) {
            int result = this.tablet_extent.compareTo(o.tablet_extent);
            if (result == 0 && (result = this.tablet_location.compareTo(o.tablet_location)) == 0) {
                result = this.tablet_session.compareTo(o.tablet_session);
            }
            return result;
        }
    }

    public static class TabletLocations {
        private final List<TabletLocation> locations;
        private final List<KeyExtent> locationless;

        public TabletLocations(List<TabletLocation> locations, List<KeyExtent> locationless) {
            this.locations = locations;
            this.locationless = locationless;
        }

        public List<TabletLocation> getLocations() {
            return this.locations;
        }

        public List<KeyExtent> getLocationless() {
            return this.locationless;
        }
    }

    private static class LocatorKey {
        String instanceId;
        TableId tableId;

        LocatorKey(String instanceId, TableId table) {
            this.instanceId = instanceId;
            this.tableId = table;
        }

        public int hashCode() {
            return this.instanceId.hashCode() + this.tableId.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof LocatorKey) {
                return this.equals((LocatorKey)o);
            }
            return false;
        }

        public boolean equals(LocatorKey lk) {
            return this.instanceId.equals(lk.instanceId) && this.tableId.equals(lk.tableId);
        }
    }
}

