/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.nio.charset.StandardCharsets;
import java.security.SecurityPermission;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.clientImpl.Namespaces;
import org.apache.accumulo.core.clientImpl.TableMap;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.core.singletons.SingletonService;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;

public class Tables {
    public static final String VALID_NAME_REGEX = "^(\\w+\\.)?(\\w+)$";
    private static final SecurityPermission TABLES_PERMISSION = new SecurityPermission("tablesPermission");
    private static Cache<String, TableMap> instanceToMapCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();

    public static TableId getTableId(ClientContext context, String tableName) throws TableNotFoundException {
        try {
            return Tables._getTableId(context, tableName);
        }
        catch (NamespaceNotFoundException e) {
            throw new TableNotFoundException(tableName, e);
        }
    }

    private static ZooCache getZooCache(ClientContext context) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(TABLES_PERMISSION);
        }
        return new ZooCacheFactory().getZooCache(context.getZooKeepers(), context.getZooKeepersSessionTimeOut());
    }

    public static TableId _getTableId(ClientContext context, String tableName) throws NamespaceNotFoundException, TableNotFoundException {
        TableId tableId = Tables.getNameToIdMap(context).get(tableName);
        if (tableId == null) {
            Tables.clearCache(context);
            tableId = Tables.getNameToIdMap(context).get(tableName);
            if (tableId == null) {
                String namespace = Tables.qualify(tableName).getFirst();
                if (Namespaces.getNameToIdMap(context).containsKey(namespace)) {
                    throw new TableNotFoundException(null, tableName, null);
                }
                throw new NamespaceNotFoundException(null, namespace, null);
            }
        }
        return tableId;
    }

    public static String getTableName(ClientContext context, TableId tableId) throws TableNotFoundException {
        String tableName = Tables.getIdToNameMap(context).get(tableId);
        if (tableName == null) {
            throw new TableNotFoundException(tableId.canonical(), null, null);
        }
        return tableName;
    }

    public static String getTableOfflineMsg(ClientContext context, TableId tableId) {
        if (tableId == null) {
            return "Table <unknown table> is offline";
        }
        try {
            String tableName = Tables.getTableName(context, tableId);
            return "Table " + tableName + " (" + tableId.canonical() + ") is offline";
        }
        catch (TableNotFoundException e) {
            return "Table <unknown table> (" + tableId.canonical() + ") is offline";
        }
    }

    public static Map<String, TableId> getNameToIdMap(ClientContext context) {
        return Tables.getTableMap(context).getNameToIdMap();
    }

    public static Map<TableId, String> getIdToNameMap(ClientContext context) {
        return Tables.getTableMap(context).getIdtoNameMap();
    }

    private static TableMap getTableMap(ClientContext context) {
        ZooCache zc = Tables.getZooCache(context);
        TableMap map = Tables.getTableMap(context, zc);
        if (!map.isCurrent(zc)) {
            instanceToMapCache.invalidate((Object)context.getInstanceID());
            map = Tables.getTableMap(context, zc);
        }
        return map;
    }

    private static TableMap getTableMap(ClientContext context, ZooCache zc) {
        try {
            return (TableMap)instanceToMapCache.get((Object)context.getInstanceID(), () -> new TableMap(context, zc));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean exists(ClientContext context, TableId tableId) {
        ZooCache zc = Tables.getZooCache(context);
        List<String> tableIds = zc.getChildren(context.getZooKeeperRoot() + "/tables");
        return tableIds.contains(tableId.canonical());
    }

    public static void clearCache(ClientContext context) {
        Tables.getZooCache(context).clear(context.getZooKeeperRoot() + "/tables");
        Tables.getZooCache(context).clear(context.getZooKeeperRoot() + "/namespaces");
        instanceToMapCache.invalidate((Object)context.getInstanceID());
    }

    public static void clearCacheByPath(ClientContext context, String zooPath) {
        String thePath = zooPath.startsWith("/") ? zooPath : "/" + zooPath;
        Tables.getZooCache(context).clear(context.getZooKeeperRoot() + thePath);
        instanceToMapCache.invalidate((Object)context.getInstanceID());
    }

    public static String getPrintableTableInfoFromId(ClientContext context, TableId tableId) {
        String tableName = null;
        try {
            tableName = Tables.getTableName(context, tableId);
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        return tableName == null ? String.format("?(ID:%s)", tableId.canonical()) : String.format("%s(ID:%s)", tableName, tableId.canonical());
    }

    public static String getPrintableTableInfoFromName(ClientContext context, String tableName) {
        TableId tableId = null;
        try {
            tableId = Tables.getTableId(context, tableName);
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        return tableId == null ? String.format("%s(?)", tableName) : String.format("%s(ID:%s)", tableName, tableId.canonical());
    }

    public static TableState getTableState(ClientContext context, TableId tableId) {
        return Tables.getTableState(context, tableId, false);
    }

    public static TableState getTableState(ClientContext context, TableId tableId, boolean clearCachedState) {
        ZooCache zc;
        byte[] state;
        String statePath = context.getZooKeeperRoot() + "/tables" + "/" + tableId.canonical() + "/state";
        if (clearCachedState) {
            Tables.clearCacheByPath(context, statePath);
        }
        if ((state = (zc = Tables.getZooCache(context)).get(statePath)) == null) {
            return TableState.UNKNOWN;
        }
        return TableState.valueOf(new String(state, StandardCharsets.UTF_8));
    }

    public static String qualified(String tableName) {
        return Tables.qualified(tableName, Namespace.DEFAULT.name());
    }

    public static String qualified(String tableName, String defaultNamespace) {
        Pair<String, String> qualifiedTableName = Tables.qualify(tableName, defaultNamespace);
        if (Namespace.DEFAULT.name().equals(qualifiedTableName.getFirst())) {
            return qualifiedTableName.getSecond();
        }
        return qualifiedTableName.toString("", ".", "");
    }

    public static Pair<String, String> qualify(String tableName) {
        return Tables.qualify(tableName, Namespace.DEFAULT.name());
    }

    public static Pair<String, String> qualify(String tableName, String defaultNamespace) {
        if (!tableName.matches(VALID_NAME_REGEX)) {
            throw new IllegalArgumentException("Invalid table name '" + tableName + "'");
        }
        if ("!METADATA".equals(tableName)) {
            tableName = MetadataTable.NAME;
        }
        if (tableName.contains(".")) {
            String[] s = tableName.split("\\.", 2);
            return new Pair<String, String>(s[0], s[1]);
        }
        return new Pair<String, String>(defaultNamespace, tableName);
    }

    public static NamespaceId getNamespaceId(ClientContext context, TableId tableId) throws TableNotFoundException {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"instance is null");
        Preconditions.checkArgument((tableId != null ? 1 : 0) != 0, (Object)"tableId is null");
        ZooCache zc = Tables.getZooCache(context);
        byte[] n = zc.get(context.getZooKeeperRoot() + "/tables" + "/" + tableId + "/namespace");
        if (n == null) {
            throw new TableNotFoundException(tableId.canonical(), null, null);
        }
        return NamespaceId.of(new String(n, StandardCharsets.UTF_8));
    }

    static {
        SingletonManager.register(new SingletonService(){
            boolean enabled = false;

            @Override
            public synchronized boolean isEnabled() {
                return this.enabled;
            }

            @Override
            public synchronized void enable() {
                this.enabled = true;
            }

            @Override
            public synchronized void disable() {
                try {
                    instanceToMapCache.invalidateAll();
                }
                finally {
                    this.enabled = false;
                }
            }
        });
    }
}

