/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ClientExec;
import org.apache.accumulo.core.clientImpl.ClientExecReturn;
import org.apache.accumulo.core.clientImpl.ThriftTransportKey;
import org.apache.accumulo.core.clientImpl.ThriftTransportPool;
import org.apache.accumulo.core.clientImpl.thrift.ClientService;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerClient {
    private static final Logger log = LoggerFactory.getLogger(ServerClient.class);
    static volatile boolean warnedAboutTServersBeingDown = false;

    public static <T> T execute(ClientContext context, ClientExecReturn<T, ClientService.Client> exec) throws AccumuloException, AccumuloSecurityException {
        return ServerClient.execute(context, new ClientService.Client.Factory(), exec);
    }

    public static <CT extends TServiceClient, RT> RT execute(ClientContext context, TServiceClientFactory<CT> factory, ClientExecReturn<RT, CT> exec) throws AccumuloException, AccumuloSecurityException {
        try {
            return ServerClient.executeRaw(context, factory, exec);
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    public static void executeVoid(ClientContext context, ClientExec<ClientService.Client> exec) throws AccumuloException, AccumuloSecurityException {
        try {
            ServerClient.executeRawVoid(context, exec);
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    public static <T> T executeRaw(ClientContext context, ClientExecReturn<T, ClientService.Client> exec) throws Exception {
        return ServerClient.executeRaw(context, new ClientService.Client.Factory(), exec);
    }

    /*
     * Exception decompiling
     */
    public static <CT extends TServiceClient, RT> RT executeRaw(ClientContext context, TServiceClientFactory<CT> factory, ClientExecReturn<RT, CT> exec) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static void executeRawVoid(ClientContext context, ClientExec<ClientService.Client> exec) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Pair<String, ClientService.Client> getConnection(ClientContext context) throws TTransportException {
        return ServerClient.getConnection(context, true);
    }

    public static <CT extends TServiceClient> Pair<String, CT> getConnection(ClientContext context, TServiceClientFactory<CT> factory) throws TTransportException {
        return ServerClient.getConnection(context, factory, true, context.getClientTimeoutInMillis());
    }

    public static Pair<String, ClientService.Client> getConnection(ClientContext context, boolean preferCachedConnections) throws TTransportException {
        return ServerClient.getConnection(context, preferCachedConnections, context.getClientTimeoutInMillis());
    }

    public static Pair<String, ClientService.Client> getConnection(ClientContext context, boolean preferCachedConnections, long rpcTimeout) throws TTransportException {
        return ServerClient.getConnection(context, new ClientService.Client.Factory(), preferCachedConnections, rpcTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <CT extends TServiceClient> Pair<String, CT> getConnection(ClientContext context, TServiceClientFactory<CT> factory, boolean preferCachedConnections, long rpcTimeout) throws TTransportException {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        ArrayList<ThriftTransportKey> servers = new ArrayList<ThriftTransportKey>();
        ZooCache zc = context.getZooCache();
        for (String tserver : zc.getChildren(context.getZooKeeperRoot() + "/tservers")) {
            String strData;
            String path = context.getZooKeeperRoot() + "/tservers" + "/" + tserver;
            byte[] data = ZooUtil.getLockData(zc, path);
            if (data == null || (strData = new String(data, StandardCharsets.UTF_8)).equals("master")) continue;
            servers.add(new ThriftTransportKey(new ServerServices(strData).getAddress(ServerServices.Service.TSERV_CLIENT), rpcTimeout, context));
        }
        boolean opened = false;
        try {
            Pair<String, TTransport> pair = ThriftTransportPool.getInstance().getAnyTransport(servers, preferCachedConnections);
            CT client = ThriftUtil.createClient(factory, pair.getSecond());
            opened = true;
            warnedAboutTServersBeingDown = false;
            Pair<String, CT> pair2 = new Pair<String, CT>(pair.getFirst(), client);
            return pair2;
        }
        finally {
            if (!opened && !warnedAboutTServersBeingDown) {
                if (servers.isEmpty()) {
                    log.warn("There are no tablet servers: check that zookeeper and accumulo are running.");
                } else {
                    log.warn("Failed to find an available server in the list of servers: {}", servers);
                }
                warnedAboutTServersBeingDown = true;
            }
        }
    }

    public static void close(TServiceClient client) {
        if (client != null && client.getInputProtocol() != null && client.getInputProtocol().getTransport() != null) {
            ThriftTransportPool.getInstance().returnTransport(client.getInputProtocol().getTransport());
        } else {
            log.debug("Attempt to close null connection to a server", (Throwable)new Exception());
        }
    }
}

