/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.IsolationException;
import org.apache.accumulo.core.clientImpl.ScannerImpl;
import org.apache.accumulo.core.clientImpl.ScannerOptions;
import org.apache.accumulo.core.clientImpl.ThriftScanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyValue;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.NamingThreadFactory;
import org.slf4j.LoggerFactory;

public class ScannerIterator
implements Iterator<Map.Entry<Key, Value>> {
    private long timeOut;
    private Iterator<KeyValue> iter;
    private final ThriftScanner.ScanState scanState;
    private ScannerOptions options;
    private Future<List<KeyValue>> readAheadOperation;
    private boolean finished = false;
    private long batchCount = 0L;
    private long readaheadThreshold;
    private ScannerImpl.Reporter reporter;
    private static ThreadPoolExecutor readaheadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 3L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NamingThreadFactory("Accumulo scanner read ahead thread"));
    private boolean closed = false;

    ScannerIterator(ClientContext context, TableId tableId, Authorizations authorizations, Range range, int size, long timeOut, ScannerOptions options, boolean isolated, long readaheadThreshold, ScannerImpl.Reporter reporter) {
        this.timeOut = timeOut;
        this.readaheadThreshold = readaheadThreshold;
        this.options = new ScannerOptions(options);
        this.reporter = reporter;
        if (this.options.fetchedColumns.size() > 0) {
            range = range.bound(this.options.fetchedColumns.first(), this.options.fetchedColumns.last());
        }
        this.scanState = new ThriftScanner.ScanState(context, tableId, authorizations, new Range(range), options.fetchedColumns, size, options.serverSideIteratorList, options.serverSideIteratorOptions, isolated, readaheadThreshold, options.getSamplerConfiguration(), options.batchTimeOut, options.classLoaderContext, options.executionHints);
        if (readaheadThreshold == 0L) {
            this.initiateReadAhead();
        }
        this.iter = null;
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.iter != null && this.iter.hasNext()) {
            return true;
        }
        this.iter = this.getNextBatch().iterator();
        if (!this.iter.hasNext()) {
            this.finished = true;
            this.reporter.finished(this);
            return false;
        }
        return true;
    }

    @Override
    public Map.Entry<Key, Value> next() {
        if (this.hasNext()) {
            return this.iter.next();
        }
        throw new NoSuchElementException();
    }

    void close() {
        readaheadPool.execute(() -> {
            ThriftScanner.ScanState scanState = this.scanState;
            synchronized (scanState) {
                try {
                    this.closed = true;
                    ThriftScanner.close(this.scanState);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(ScannerIterator.class).debug("Exception when closing scan session", (Throwable)e);
                }
            }
        });
    }

    private void initiateReadAhead() {
        Preconditions.checkState((this.readAheadOperation == null ? 1 : 0) != 0);
        this.readAheadOperation = readaheadPool.submit(this::readBatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<KeyValue> readBatch() throws Exception {
        List<KeyValue> batch;
        do {
            ThriftScanner.ScanState scanState = this.scanState;
            synchronized (scanState) {
                Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Scanner was closed");
                batch = ThriftScanner.scan(this.scanState.context, this.scanState, this.timeOut);
            }
        } while (batch != null && batch.size() == 0);
        if (batch != null) {
            this.reporter.readBatch(this);
        }
        return batch == null ? Collections.emptyList() : batch;
    }

    private List<KeyValue> getNextBatch() {
        List<KeyValue> nextBatch;
        try {
            if (this.readAheadOperation == null) {
                nextBatch = this.readBatch();
            } else {
                nextBatch = this.readAheadOperation.get();
                this.readAheadOperation = null;
            }
        }
        catch (ExecutionException ee) {
            this.wrapExecutionException(ee);
            throw new RuntimeException(ee);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!nextBatch.isEmpty()) {
            ++this.batchCount;
            if (this.batchCount > this.readaheadThreshold) {
                this.initiateReadAhead();
            }
        }
        return nextBatch;
    }

    private void wrapExecutionException(ExecutionException ee) {
        if (ee.getCause() instanceof IsolationException) {
            throw new IsolationException(ee);
        }
        if (ee.getCause() instanceof TableDeletedException) {
            TableDeletedException cause = (TableDeletedException)ee.getCause();
            throw new TableDeletedException(cause.getTableId(), cause);
        }
        if (ee.getCause() instanceof TableOfflineException) {
            throw new TableOfflineException(ee);
        }
        if (ee.getCause() instanceof SampleNotPresentException) {
            throw new SampleNotPresentException(ee.getCause().getMessage(), ee);
        }
    }
}

