/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ScannerIterator;
import org.apache.accumulo.core.clientImpl.ScannerOptions;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;

public class ScannerImpl
extends ScannerOptions
implements Scanner {
    private final ClientContext context;
    private Authorizations authorizations;
    private TableId tableId;
    private int size;
    private Range range;
    private boolean isolated = false;
    private long readaheadThreshold = 3L;
    boolean closed = false;
    private static final int MAX_ENTRIES = 16;
    private long iterCount = 0L;
    private Map<ScannerIterator, Long> iters = new LinkedHashMap<ScannerIterator, Long>(17, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean removeEldestEntry(Map.Entry<ScannerIterator, Long> eldest) {
            return this.size() > 16;
        }
    };

    private synchronized void ensureOpen() {
        if (this.closed) {
            throw new IllegalArgumentException("Scanner is closed");
        }
    }

    public ScannerImpl(ClientContext context, TableId tableId, Authorizations authorizations) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        Preconditions.checkArgument((tableId != null ? 1 : 0) != 0, (Object)"tableId is null");
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        this.context = context;
        this.tableId = tableId;
        this.range = new Range((Key)null, (Key)null);
        this.authorizations = authorizations;
        this.size = 1000;
    }

    @Override
    public synchronized void setRange(Range range) {
        this.ensureOpen();
        Preconditions.checkArgument((range != null ? 1 : 0) != 0, (Object)"range is null");
        this.range = range;
    }

    @Override
    public synchronized Range getRange() {
        this.ensureOpen();
        return this.range;
    }

    @Override
    public synchronized void setBatchSize(int size) {
        this.ensureOpen();
        if (size <= 0) {
            throw new IllegalArgumentException("size must be greater than zero");
        }
        this.size = size;
    }

    @Override
    public synchronized int getBatchSize() {
        this.ensureOpen();
        return this.size;
    }

    @Override
    public synchronized Iterator<Map.Entry<Key, Value>> iterator() {
        this.ensureOpen();
        ScannerIterator iter = new ScannerIterator(this.context, this.tableId, this.authorizations, this.range, this.size, this.getTimeout(TimeUnit.SECONDS), this, this.isolated, this.readaheadThreshold, new Reporter());
        this.iters.put(iter, this.iterCount++);
        return iter;
    }

    @Override
    public Authorizations getAuthorizations() {
        this.ensureOpen();
        return this.authorizations;
    }

    @Override
    public synchronized void enableIsolation() {
        this.ensureOpen();
        this.isolated = true;
    }

    @Override
    public synchronized void disableIsolation() {
        this.ensureOpen();
        this.isolated = false;
    }

    @Override
    public synchronized void setReadaheadThreshold(long batches) {
        this.ensureOpen();
        if (batches < 0L) {
            throw new IllegalArgumentException("Number of batches before read-ahead must be non-negative");
        }
        this.readaheadThreshold = batches;
    }

    @Override
    public synchronized long getReadaheadThreshold() {
        this.ensureOpen();
        return this.readaheadThreshold;
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.iters.forEach((? super K iter, ? super V v) -> iter.close());
            this.iters.clear();
        }
        this.closed = true;
    }

    class Reporter {
        Reporter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readBatch(ScannerIterator iter) {
            ScannerImpl scannerImpl = ScannerImpl.this;
            synchronized (scannerImpl) {
                ScannerImpl.this.iters.get(iter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finished(ScannerIterator iter) {
            ScannerImpl scannerImpl = ScannerImpl.this;
            synchronized (scannerImpl) {
                ScannerImpl.this.iters.remove(iter);
            }
        }
    }
}

