/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.admin.NamespaceOperations;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.iterators.IteratorUtil;

public abstract class NamespaceOperationsHelper
implements NamespaceOperations {
    @Override
    public String systemNamespace() {
        return Namespace.ACCUMULO.name();
    }

    @Override
    public String defaultNamespace() {
        return Namespace.DEFAULT.name();
    }

    @Override
    public void attachIterator(String namespace, IteratorSetting setting) throws AccumuloSecurityException, AccumuloException, NamespaceNotFoundException {
        this.attachIterator(namespace, setting, EnumSet.allOf(IteratorUtil.IteratorScope.class));
    }

    @Override
    public void attachIterator(String namespace, IteratorSetting setting, EnumSet<IteratorUtil.IteratorScope> scopes) throws AccumuloSecurityException, AccumuloException, NamespaceNotFoundException {
        this.checkIteratorConflicts(namespace, setting, scopes);
        for (IteratorUtil.IteratorScope scope : scopes) {
            String root = String.format("%s%s.%s", new Object[]{Property.TABLE_ITERATOR_PREFIX, scope.name().toLowerCase(), setting.getName()});
            for (Map.Entry<String, String> prop : setting.getOptions().entrySet()) {
                this.setProperty(namespace, root + ".opt." + prop.getKey(), prop.getValue());
            }
            this.setProperty(namespace, root, setting.getPriority() + "," + setting.getIteratorClass());
        }
    }

    @Override
    public void removeIterator(String namespace, String name, EnumSet<IteratorUtil.IteratorScope> scopes) throws AccumuloSecurityException, AccumuloException, NamespaceNotFoundException {
        if (!this.exists(namespace)) {
            throw new NamespaceNotFoundException(null, namespace, null);
        }
        TreeMap<String, String> copy = new TreeMap<String, String>();
        for (Map.Entry<String, String> property : this.getProperties(namespace)) {
            copy.put(property.getKey(), property.getValue());
        }
        for (IteratorUtil.IteratorScope scope : scopes) {
            String root = String.format("%s%s.%s", new Object[]{Property.TABLE_ITERATOR_PREFIX, scope.name().toLowerCase(), name});
            for (Map.Entry property : copy.entrySet()) {
                if (!((String)property.getKey()).equals(root) && !((String)property.getKey()).startsWith(root + ".opt.")) continue;
                this.removeProperty(namespace, (String)property.getKey());
            }
        }
    }

    @Override
    public IteratorSetting getIteratorSetting(String namespace, String name, IteratorUtil.IteratorScope scope) throws AccumuloSecurityException, AccumuloException, NamespaceNotFoundException {
        if (!this.exists(namespace)) {
            throw new NamespaceNotFoundException(null, namespace, null);
        }
        int priority = -1;
        String classname = null;
        HashMap<String, String> settings = new HashMap<String, String>();
        String root = String.format("%s%s.%s", new Object[]{Property.TABLE_ITERATOR_PREFIX, scope.name().toLowerCase(), name});
        String opt = root + ".opt.";
        for (Map.Entry<String, String> property : this.getProperties(namespace)) {
            if (property.getKey().equals(root)) {
                String[] parts = property.getValue().split(",");
                if (parts.length != 2) {
                    throw new AccumuloException("Bad value for iterator setting: " + property.getValue());
                }
                priority = Integer.parseInt(parts[0]);
                classname = parts[1];
                continue;
            }
            if (!property.getKey().startsWith(opt)) continue;
            settings.put(property.getKey().substring(opt.length()), property.getValue());
        }
        if (priority <= 0 || classname == null) {
            return null;
        }
        return new IteratorSetting(priority, name, classname, settings);
    }

    @Override
    public Map<String, EnumSet<IteratorUtil.IteratorScope>> listIterators(String namespace) throws AccumuloSecurityException, AccumuloException, NamespaceNotFoundException {
        if (!this.exists(namespace)) {
            throw new NamespaceNotFoundException(null, namespace, null);
        }
        TreeMap<String, EnumSet<IteratorUtil.IteratorScope>> result = new TreeMap<String, EnumSet<IteratorUtil.IteratorScope>>();
        for (Map.Entry<String, String> property : this.getProperties(namespace)) {
            String name = property.getKey();
            String[] parts = name.split("\\.");
            if (parts.length != 4 || !parts[0].equals("table") || !parts[1].equals("iterator")) continue;
            IteratorUtil.IteratorScope scope = IteratorUtil.IteratorScope.valueOf(parts[2]);
            if (!result.containsKey(parts[3])) {
                result.put(parts[3], EnumSet.noneOf(IteratorUtil.IteratorScope.class));
            }
            ((EnumSet)result.get(parts[3])).add(scope);
        }
        return result;
    }

    @Override
    public void checkIteratorConflicts(String namespace, IteratorSetting setting, EnumSet<IteratorUtil.IteratorScope> scopes) throws AccumuloException, NamespaceNotFoundException, AccumuloSecurityException {
        if (!this.exists(namespace)) {
            throw new NamespaceNotFoundException(null, namespace, null);
        }
        for (IteratorUtil.IteratorScope scope : scopes) {
            String scopeStr = String.format("%s%s", new Object[]{Property.TABLE_ITERATOR_PREFIX, scope.name().toLowerCase()});
            String nameStr = String.format("%s.%s", scopeStr, setting.getName());
            String optStr = String.format("%s.opt.", nameStr);
            TreeMap<String, String> optionConflicts = new TreeMap<String, String>();
            for (Map.Entry<String, String> property : this.getProperties(namespace)) {
                if (!property.getKey().startsWith(scopeStr)) continue;
                if (property.getKey().equals(nameStr)) {
                    throw new AccumuloException(new IllegalArgumentException("iterator name conflict for " + setting.getName() + ": " + property.getKey() + "=" + property.getValue()));
                }
                if (property.getKey().startsWith(optStr)) {
                    optionConflicts.put(property.getKey(), property.getValue());
                }
                if (property.getKey().contains(".opt.")) continue;
                String[] parts = property.getValue().split(",");
                if (parts.length != 2) {
                    throw new AccumuloException("Bad value for existing iterator setting: " + property.getKey() + "=" + property.getValue());
                }
                try {
                    if (Integer.parseInt(parts[0]) != setting.getPriority()) continue;
                    throw new AccumuloException(new IllegalArgumentException("iterator priority conflict: " + property.getKey() + "=" + property.getValue()));
                }
                catch (NumberFormatException e) {
                    throw new AccumuloException("Bad value for existing iterator setting: " + property.getKey() + "=" + property.getValue());
                }
            }
            if (optionConflicts.size() <= 0) continue;
            throw new AccumuloException(new IllegalArgumentException("iterator options conflict for " + setting.getName() + ": " + optionConflicts));
        }
    }

    @Override
    public int addConstraint(String namespace, String constraintClassName) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException {
        int i;
        TreeSet<Integer> constraintNumbers = new TreeSet<Integer>();
        TreeMap<String, Integer> constraintClasses = new TreeMap<String, Integer>();
        for (Map.Entry<String, String> property : this.getProperties(namespace)) {
            if (!property.getKey().startsWith(Property.TABLE_CONSTRAINT_PREFIX.toString())) continue;
            try {
                i = Integer.parseInt(property.getKey().substring(Property.TABLE_CONSTRAINT_PREFIX.toString().length()));
            }
            catch (NumberFormatException e) {
                throw new AccumuloException("Bad key for existing constraint: " + property);
            }
            constraintNumbers.add(i);
            constraintClasses.put(property.getValue(), i);
        }
        i = 1;
        while (constraintNumbers.contains(i)) {
            ++i;
        }
        if (constraintClasses.containsKey(constraintClassName)) {
            throw new AccumuloException("Constraint " + constraintClassName + " already exists for namespace " + namespace + " with number " + constraintClasses.get(constraintClassName));
        }
        this.setProperty(namespace, Property.TABLE_CONSTRAINT_PREFIX.toString() + i, constraintClassName);
        return i;
    }

    @Override
    public void removeConstraint(String namespace, int number) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException {
        this.removeProperty(namespace, Property.TABLE_CONSTRAINT_PREFIX.toString() + number);
    }

    @Override
    public Map<String, Integer> listConstraints(String namespace) throws AccumuloException, NamespaceNotFoundException, AccumuloSecurityException {
        TreeMap<String, Integer> constraints = new TreeMap<String, Integer>();
        for (Map.Entry<String, String> property : this.getProperties(namespace)) {
            if (!property.getKey().startsWith(Property.TABLE_CONSTRAINT_PREFIX.toString())) continue;
            if (constraints.containsKey(property.getValue())) {
                throw new AccumuloException("Same constraint configured twice: " + property.getKey() + "=" + (Object)((Object)Property.TABLE_CONSTRAINT_PREFIX) + constraints.get(property.getValue()) + "=" + property.getKey());
            }
            try {
                constraints.put(property.getValue(), Integer.parseInt(property.getKey().substring(Property.TABLE_CONSTRAINT_PREFIX.toString().length())));
            }
            catch (NumberFormatException e) {
                throw new AccumuloException("Bad key for existing constraint: " + property);
            }
        }
        return constraints;
    }
}

