/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.clientImpl.TabletServerBatchWriter;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTableBatchWriterImpl
implements MultiTableBatchWriter {
    private static final Logger log = LoggerFactory.getLogger(MultiTableBatchWriterImpl.class);
    private AtomicBoolean closed;
    private TabletServerBatchWriter bw;
    private ConcurrentHashMap<TableId, BatchWriter> tableWriters;
    private final ClientContext context;

    public MultiTableBatchWriterImpl(ClientContext context, BatchWriterConfig config) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config is null");
        this.context = context;
        this.bw = new TabletServerBatchWriter(context, config);
        this.tableWriters = new ConcurrentHashMap();
        this.closed = new AtomicBoolean(false);
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() throws MutationsRejectedException {
        this.closed.set(true);
        this.bw.close();
    }

    protected void finalize() {
        if (!this.closed.get()) {
            log.warn("{} not shutdown; did you forget to call close()?", (Object)MultiTableBatchWriterImpl.class.getSimpleName());
            try {
                this.close();
            }
            catch (MutationsRejectedException mre) {
                log.error(MultiTableBatchWriterImpl.class.getSimpleName() + " internal error.", (Throwable)mre);
                throw new RuntimeException("Exception when closing " + MultiTableBatchWriterImpl.class.getSimpleName(), mre);
            }
        }
    }

    private TableId getId(String tableName) throws TableNotFoundException {
        try {
            return Tables.getTableId(this.context, tableName);
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            log.error("Unexpected exception when fetching table id for {}", (Object)tableName);
            if (cause == null) {
                throw new RuntimeException(e);
            }
            if (cause instanceof TableNotFoundException) {
                throw (TableNotFoundException)cause;
            }
            if (cause instanceof TableOfflineException) {
                throw (TableOfflineException)cause;
            }
            throw e;
        }
    }

    @Override
    public BatchWriter getBatchWriter(String tableName) throws TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        TableId tableId = this.getId(tableName);
        BatchWriter tbw = this.tableWriters.get(tableId);
        if (tbw == null) {
            tbw = new TableBatchWriter(tableId);
            BatchWriter current = this.tableWriters.putIfAbsent(tableId, tbw);
            return current != null ? current : tbw;
        }
        return tbw;
    }

    @Override
    public void flush() throws MutationsRejectedException {
        this.bw.flush();
    }

    private class TableBatchWriter
    implements BatchWriter {
        private TableId tableId;

        TableBatchWriter(TableId tableId) {
            this.tableId = tableId;
        }

        @Override
        public void addMutation(Mutation m) throws MutationsRejectedException {
            Preconditions.checkArgument((m != null ? 1 : 0) != 0, (Object)"m is null");
            MultiTableBatchWriterImpl.this.bw.addMutation(this.tableId, m);
        }

        @Override
        public void addMutations(Iterable<Mutation> iterable) throws MutationsRejectedException {
            MultiTableBatchWriterImpl.this.bw.addMutation(this.tableId, iterable.iterator());
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException("Must close all tables, can not close an individual table");
        }

        @Override
        public void flush() {
            throw new UnsupportedOperationException("Must flush all tables, can not flush an individual table");
        }
    }
}

