/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.DelegationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.AuthenticationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegationTokenImpl
extends PasswordToken
implements DelegationToken {
    private static final Logger log = LoggerFactory.getLogger(DelegationTokenImpl.class);
    public static final String SERVICE_NAME = "AccumuloDelegationToken";
    private AuthenticationTokenIdentifier identifier;

    public DelegationTokenImpl() {
    }

    public DelegationTokenImpl(byte[] delegationTokenPassword, AuthenticationTokenIdentifier identifier) {
        Objects.requireNonNull(delegationTokenPassword);
        Objects.requireNonNull(identifier);
        this.setPassword(delegationTokenPassword);
        this.identifier = identifier;
    }

    public DelegationTokenImpl(String instanceID, UserGroupInformation user, AuthenticationTokenIdentifier identifier) {
        Objects.requireNonNull(instanceID);
        Objects.requireNonNull(user);
        Objects.requireNonNull(identifier);
        Credentials creds = user.getCredentials();
        Token token = creds.getToken(new Text("AccumuloDelegationToken-" + instanceID));
        if (token == null) {
            throw new IllegalArgumentException("Did not find Accumulo delegation token in provided UserGroupInformation");
        }
        this.setPasswordFromToken((Token<? extends TokenIdentifier>)token, identifier);
    }

    public DelegationTokenImpl(Token<? extends TokenIdentifier> token, AuthenticationTokenIdentifier identifier) {
        Objects.requireNonNull(token);
        Objects.requireNonNull(identifier);
        this.setPasswordFromToken(token, identifier);
    }

    private void setPasswordFromToken(Token<? extends TokenIdentifier> token, AuthenticationTokenIdentifier identifier) {
        if (!AuthenticationTokenIdentifier.TOKEN_KIND.equals((Object)token.getKind())) {
            String msg = "Expected an AuthenticationTokenIdentifier but got a " + token.getKind();
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        this.setPassword(token.getPassword());
        this.identifier = identifier;
    }

    public AuthenticationTokenIdentifier getIdentifier() {
        return this.identifier;
    }

    public Text getServiceName() {
        Objects.requireNonNull(this.identifier);
        return new Text("AccumuloDelegationToken-" + this.identifier.getInstanceId());
    }

    @Override
    public void init(AuthenticationToken.Properties properties) {
    }

    @Override
    public Set<AuthenticationToken.TokenProperty> getProperties() {
        return Collections.emptySet();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.identifier.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.identifier = new AuthenticationTokenIdentifier();
        this.identifier.readFields(in);
    }

    @Override
    public DelegationTokenImpl clone() {
        DelegationTokenImpl copy = (DelegationTokenImpl)super.clone();
        copy.setPassword(this.getPassword());
        copy.identifier = new AuthenticationTokenIdentifier(this.identifier);
        return copy;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.identifier.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.identifier.equals((Object)((DelegationTokenImpl)obj).identifier);
    }
}

