/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.admin.CompactionStrategyConfig;

public class CompactionStrategyConfigUtil {
    public static final CompactionStrategyConfig DEFAULT_STRATEGY = new CompactionStrategyConfig("org.apache.accumulo.tserver.compaction.EverythingCompactionStrategy"){

        @Override
        public CompactionStrategyConfig setOptions(Map<String, String> opts) {
            throw new UnsupportedOperationException();
        }
    };
    private static final int MAGIC = -866230236;

    public static void encode(DataOutput dout, CompactionStrategyConfig csc) throws IOException {
        dout.writeInt(-866230236);
        dout.writeByte(1);
        dout.writeUTF(csc.getClassName());
        dout.writeInt(csc.getOptions().size());
        for (Map.Entry<String, String> entry : csc.getOptions().entrySet()) {
            dout.writeUTF(entry.getKey());
            dout.writeUTF(entry.getValue());
        }
    }

    public static byte[] encode(CompactionStrategyConfig csc) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            CompactionStrategyConfigUtil.encode(dos, csc);
            dos.close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static CompactionStrategyConfig decode(DataInput din) throws IOException {
        if (din.readInt() != -866230236) {
            throw new IllegalArgumentException("Unexpected MAGIC ");
        }
        if (din.readByte() != 1) {
            throw new IllegalArgumentException("Unexpected version");
        }
        String classname = din.readUTF();
        int numEntries = din.readInt();
        HashMap<String, String> opts = new HashMap<String, String>();
        for (int i = 0; i < numEntries; ++i) {
            String k = din.readUTF();
            String v = din.readUTF();
            opts.put(k, v);
        }
        return new CompactionStrategyConfig(classname).setOptions(opts);
    }

    public static CompactionStrategyConfig decode(byte[] encodedCsc) {
        ByteArrayInputStream bais = new ByteArrayInputStream(encodedCsc);
        DataInputStream dis = new DataInputStream(bais);
        try {
            return CompactionStrategyConfigUtil.decode(dis);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

