/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.CredentialProviderFactoryShim;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.rpc.SaslConnectionParams;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConfConverter {
    private static final Logger log = LoggerFactory.getLogger(ClientConfConverter.class);
    private static Map<String, String> confProps = new HashMap<String, String>();
    private static Map<String, String> propsConf = new HashMap<String, String>();

    private static void init() {
        propsConf.put(ClientProperty.INSTANCE_ZOOKEEPERS.getKey(), ClientConfiguration.ClientProperty.INSTANCE_ZK_HOST.getKey());
        propsConf.put(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT.getKey(), ClientConfiguration.ClientProperty.INSTANCE_ZK_TIMEOUT.getKey());
        propsConf.put(ClientProperty.SSL_ENABLED.getKey(), ClientConfiguration.ClientProperty.INSTANCE_RPC_SSL_ENABLED.getKey());
        propsConf.put(ClientProperty.SSL_KEYSTORE_PATH.getKey(), ClientConfiguration.ClientProperty.RPC_SSL_KEYSTORE_PATH.getKey());
        propsConf.put(ClientProperty.SSL_KEYSTORE_TYPE.getKey(), ClientConfiguration.ClientProperty.RPC_SSL_KEYSTORE_TYPE.getKey());
        propsConf.put(ClientProperty.SSL_KEYSTORE_PASSWORD.getKey(), ClientConfiguration.ClientProperty.RPC_SSL_KEYSTORE_PASSWORD.getKey());
        propsConf.put(ClientProperty.SSL_TRUSTSTORE_PATH.getKey(), ClientConfiguration.ClientProperty.RPC_SSL_TRUSTSTORE_PATH.getKey());
        propsConf.put(ClientProperty.SSL_TRUSTSTORE_TYPE.getKey(), ClientConfiguration.ClientProperty.RPC_SSL_TRUSTSTORE_TYPE.getKey());
        propsConf.put(ClientProperty.SSL_TRUSTSTORE_PASSWORD.getKey(), ClientConfiguration.ClientProperty.RPC_SSL_TRUSTSTORE_PASSWORD.getKey());
        propsConf.put(ClientProperty.SSL_USE_JSSE.getKey(), ClientConfiguration.ClientProperty.RPC_USE_JSSE.getKey());
        propsConf.put(ClientProperty.SASL_ENABLED.getKey(), ClientConfiguration.ClientProperty.INSTANCE_RPC_SASL_ENABLED.getKey());
        propsConf.put(ClientProperty.SASL_QOP.getKey(), ClientConfiguration.ClientProperty.RPC_SASL_QOP.getKey());
        propsConf.put(ClientProperty.SASL_KERBEROS_SERVER_PRIMARY.getKey(), ClientConfiguration.ClientProperty.KERBEROS_SERVER_PRIMARY.getKey());
        for (Map.Entry<String, String> entry : propsConf.entrySet()) {
            confProps.put(entry.getValue(), entry.getKey());
        }
    }

    public static ClientConfiguration toClientConf(Properties properties) {
        ClientConfiguration config = ClientConfiguration.create();
        for (Object keyObj : properties.keySet()) {
            String propKey = (String)keyObj;
            String val = properties.getProperty(propKey);
            String confKey = propsConf.get(propKey);
            if (confKey == null) {
                config.setProperty(propKey, val);
            } else {
                config.setProperty(confKey, val);
            }
            if (!propKey.equals(ClientProperty.SSL_KEYSTORE_PATH.getKey())) continue;
            config.setProperty(ClientConfiguration.ClientProperty.INSTANCE_RPC_SSL_CLIENT_AUTH, "true");
        }
        return config;
    }

    public static Properties toProperties(ClientConfiguration clientConf) {
        Properties props = new Properties();
        Iterator<String> clientConfIter = clientConf.getKeys();
        while (clientConfIter.hasNext()) {
            String confKey = clientConfIter.next();
            String val = clientConf.getString(confKey);
            String propKey = confProps.get(confKey);
            if (propKey == null) {
                if (confKey.equals(ClientConfiguration.ClientProperty.INSTANCE_RPC_SSL_CLIENT_AUTH.getKey())) continue;
                props.setProperty(confKey, val);
                continue;
            }
            props.setProperty(propKey, val);
        }
        return props;
    }

    public static Properties toProperties(AccumuloConfiguration config) {
        return ClientConfConverter.toProperties(ClientConfConverter.toClientConf(config));
    }

    public static AccumuloConfiguration toAccumuloConf(Properties properties) {
        return ClientConfConverter.toAccumuloConf(ClientConfConverter.toClientConf(properties));
    }

    public static AccumuloConfiguration toAccumuloConf(final ClientConfiguration config) {
        final DefaultConfiguration defaults = DefaultConfiguration.getInstance();
        return new AccumuloConfiguration(){

            @Override
            public String get(Property property) {
                Configuration hadoopConf;
                String key = property.getKey();
                if (property.isSensitive() && (hadoopConf = this.getHadoopConfiguration()) != null) {
                    char[] value = CredentialProviderFactoryShim.getValueFromCredentialProvider(hadoopConf, key);
                    if (value != null) {
                        log.trace("Loaded sensitive value for {} from CredentialProvider", (Object)key);
                        return new String(value);
                    }
                    log.trace("Tried to load sensitive value for {} from CredentialProvider, but none was found", (Object)key);
                }
                if (config.containsKey(key)) {
                    return config.getString(key);
                }
                if (property == Property.GENERAL_KERBEROS_PRINCIPAL && config.containsKey(ClientConfiguration.ClientProperty.KERBEROS_SERVER_PRIMARY.getKey())) {
                    return config.getString(ClientConfiguration.ClientProperty.KERBEROS_SERVER_PRIMARY.getKey()) + "/_HOST@" + SaslConnectionParams.getDefaultRealm();
                }
                return defaults.get(property);
            }

            @Override
            public void getProperties(Map<String, String> props, Predicate<String> filter) {
                Configuration hadoopConf;
                defaults.getProperties(props, filter);
                Iterator<String> keyIter = config.getKeys();
                while (keyIter.hasNext()) {
                    String key = keyIter.next();
                    if (!filter.test(key)) continue;
                    props.put(key, config.getString(key));
                }
                if (props.containsKey(ClientConfiguration.ClientProperty.KERBEROS_SERVER_PRIMARY.getKey())) {
                    String serverPrimary = props.remove(ClientConfiguration.ClientProperty.KERBEROS_SERVER_PRIMARY.getKey());
                    if (filter.test(Property.GENERAL_KERBEROS_PRINCIPAL.getKey())) {
                        props.put(Property.GENERAL_KERBEROS_PRINCIPAL.getKey(), serverPrimary + "/_HOST@" + SaslConnectionParams.getDefaultRealm());
                    }
                }
                if ((hadoopConf = this.getHadoopConfiguration()) != null) {
                    for (String key : CredentialProviderFactoryShim.getKeys(hadoopConf)) {
                        char[] value;
                        if (!Property.isValidPropertyKey(key) || !Property.isSensitive(key) || !filter.test(key) || (value = CredentialProviderFactoryShim.getValueFromCredentialProvider(hadoopConf, key)) == null) continue;
                        props.put(key, new String(value));
                    }
                }
            }

            private Configuration getHadoopConfiguration() {
                String credProviderPaths = config.getString(Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS.getKey());
                if (credProviderPaths != null && !credProviderPaths.isEmpty()) {
                    Configuration hConf = new Configuration();
                    hConf.set("hadoop.security.credential.provider.path", credProviderPaths);
                    return hConf;
                }
                log.trace("Did not find credential provider configuration in ClientConfiguration");
                return null;
            }
        };
    }

    public static ClientConfiguration toClientConf(AccumuloConfiguration conf) {
        ClientConfiguration clientConf = ClientConfiguration.create();
        String serverPrincipal = conf.get(Property.GENERAL_KERBEROS_PRINCIPAL);
        if (serverPrincipal != null && !serverPrincipal.isEmpty()) {
            KerberosName krbName = new KerberosName(serverPrincipal);
            clientConf.setProperty(ClientConfiguration.ClientProperty.KERBEROS_SERVER_PRIMARY, krbName.getServiceName());
        }
        HashSet<String> clientKeys = new HashSet<String>();
        for (ClientConfiguration.ClientProperty prop : ClientConfiguration.ClientProperty.values()) {
            clientKeys.add(prop.getKey());
        }
        for (Map.Entry<String, String> entry : conf) {
            String key = entry.getKey();
            if (!clientKeys.contains(key)) continue;
            clientConf.setProperty(key, entry.getValue());
        }
        return clientConf;
    }

    static {
        ClientConfConverter.init();
    }
}

