/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.lexicoder;

import org.apache.accumulo.core.client.lexicoder.Lexicoder;
import org.apache.accumulo.core.clientImpl.lexicoder.AbstractLexicoder;
import org.apache.accumulo.core.clientImpl.lexicoder.ByteUtils;

public class ReverseLexicoder<T>
extends AbstractLexicoder<T> {
    private Lexicoder<T> lexicoder;

    public ReverseLexicoder(Lexicoder<T> lexicoder) {
        this.lexicoder = lexicoder;
    }

    @Override
    public byte[] encode(T data) {
        byte[] bytes = ByteUtils.escape(this.lexicoder.encode(data));
        byte[] ret = new byte[bytes.length + 1];
        for (int i = 0; i < bytes.length; ++i) {
            ret[i] = (byte)(255 - (0xFF & bytes[i]));
        }
        ret[bytes.length] = -1;
        return ret;
    }

    @Override
    protected T decodeUnchecked(byte[] data, int offset, int len) {
        byte[] ret = new byte[len - 1];
        for (int i = 0; i < ret.length; ++i) {
            int dataIndex = offset + i;
            ret[i] = (byte)(255 - (0xFF & data[dataIndex]));
        }
        return this.lexicoder.decode(ByteUtils.unescape(ret));
    }
}

