/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.lexicoder;

import org.apache.accumulo.core.client.lexicoder.UIntegerLexicoder;
import org.apache.accumulo.core.clientImpl.lexicoder.AbstractLexicoder;

public class FloatLexicoder
extends AbstractLexicoder<Float> {
    private UIntegerLexicoder intEncoder = new UIntegerLexicoder();

    @Override
    public byte[] encode(Float f) {
        int i = Float.floatToRawIntBits(f.floatValue());
        i = i < 0 ? (i ^= 0xFFFFFFFF) : (i ^= Integer.MIN_VALUE);
        return this.intEncoder.encode(i);
    }

    @Override
    public Float decode(byte[] b) {
        return (Float)super.decode(b);
    }

    @Override
    protected Float decodeUnchecked(byte[] b, int offset, int len) {
        int i = this.intEncoder.decodeUnchecked(b, offset, len);
        i = i < 0 ? (i ^= Integer.MIN_VALUE) : (i ^= 0xFFFFFFFF);
        return Float.valueOf(Float.intBitsToFloat(i));
    }
}

