/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientConfConverter;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ClientInfoImpl;
import org.apache.accumulo.core.clientImpl.ConnectorImpl;
import org.apache.accumulo.core.clientImpl.InstanceOperationsImpl;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ZooKeeperInstance
implements Instance {
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperInstance.class);
    private String instanceId = null;
    private String instanceName = null;
    private final ZooCache zooCache;
    private final String zooKeepers;
    private final int zooKeepersSessionTimeOut;
    private ClientConfiguration clientConf;

    public ZooKeeperInstance(String instanceName, String zooKeepers) {
        this(ClientConfiguration.loadDefault().withInstance(instanceName).withZkHosts(zooKeepers));
    }

    ZooKeeperInstance(ClientConfiguration config, ZooCacheFactory zcf) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config is null");
        SingletonManager.setMode(SingletonManager.Mode.CONNECTOR);
        this.clientConf = config;
        this.instanceId = this.clientConf.get(ClientConfiguration.ClientProperty.INSTANCE_ID);
        this.instanceName = this.clientConf.get(ClientConfiguration.ClientProperty.INSTANCE_NAME);
        if (this.instanceId == null == (this.instanceName == null)) {
            throw new IllegalArgumentException("Expected exactly one of instanceName and instanceId to be set; " + (this.instanceName == null ? "neither" : "both") + " were set");
        }
        this.zooKeepers = this.clientConf.get(ClientConfiguration.ClientProperty.INSTANCE_ZK_HOST);
        this.zooKeepersSessionTimeOut = (int)ConfigurationTypeHelper.getTimeInMillis(this.clientConf.get(ClientConfiguration.ClientProperty.INSTANCE_ZK_TIMEOUT));
        this.zooCache = zcf.getZooCache(this.zooKeepers, this.zooKeepersSessionTimeOut);
        if (this.instanceName != null) {
            this.getInstanceID();
        }
    }

    public ZooKeeperInstance(ClientConfiguration config) {
        this(config, new ZooCacheFactory());
    }

    @Override
    public String getInstanceID() {
        if (this.instanceId == null) {
            String instanceNamePath = "/accumulo/instances/" + this.instanceName;
            byte[] iidb = this.zooCache.get(instanceNamePath);
            if (iidb == null) {
                throw new RuntimeException("Instance name " + this.instanceName + " does not exist in zookeeper. Run \"accumulo org.apache.accumulo.server.util.ListInstances\" to see a list.");
            }
            this.instanceId = new String(iidb, StandardCharsets.UTF_8);
        }
        if (this.zooCache.get("/accumulo/" + this.instanceId) == null) {
            if (this.instanceName == null) {
                throw new RuntimeException("Instance id " + this.instanceId + " does not exist in zookeeper");
            }
            throw new RuntimeException("Instance id " + this.instanceId + " pointed to by the name " + this.instanceName + " does not exist in zookeeper");
        }
        return this.instanceId;
    }

    @Override
    public List<String> getMasterLocations() {
        String masterLocPath = ZooUtil.getRoot(this.getInstanceID()) + "/masters/lock";
        OpTimer timer = null;
        if (log.isTraceEnabled()) {
            log.trace("tid={} Looking up master location in zookeeper.", (Object)Thread.currentThread().getId());
            timer = new OpTimer().start();
        }
        byte[] loc = ZooUtil.getLockData(this.zooCache, masterLocPath);
        if (timer != null) {
            timer.stop();
            log.trace("tid={} Found master at {} in {}", new Object[]{Thread.currentThread().getId(), loc == null ? "null" : new String(loc, StandardCharsets.UTF_8), String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
        }
        if (loc == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new String(loc, StandardCharsets.UTF_8));
    }

    @Override
    public String getRootTabletLocation() {
        String zRootLocPath = ZooUtil.getRoot(this.getInstanceID()) + "/root_tablet/location";
        OpTimer timer = null;
        if (log.isTraceEnabled()) {
            log.trace("tid={} Looking up root tablet location in zookeeper.", (Object)Thread.currentThread().getId());
            timer = new OpTimer().start();
        }
        byte[] loc = this.zooCache.get(zRootLocPath);
        if (timer != null) {
            timer.stop();
            log.trace("tid={} Found root tablet at {} in {}", new Object[]{Thread.currentThread().getId(), loc == null ? "null" : new String(loc, StandardCharsets.UTF_8), String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
        }
        if (loc == null) {
            return null;
        }
        return new String(loc, StandardCharsets.UTF_8).split("\\|")[0];
    }

    @Override
    public String getInstanceName() {
        if (this.instanceName == null) {
            this.instanceName = InstanceOperationsImpl.lookupInstanceName(this.zooCache, UUID.fromString(this.getInstanceID()));
        }
        return this.instanceName;
    }

    @Override
    public String getZooKeepers() {
        return this.zooKeepers;
    }

    @Override
    public int getZooKeepersSessionTimeOut() {
        return this.zooKeepersSessionTimeOut;
    }

    @Override
    public Connector getConnector(String principal, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        Properties properties = ClientConfConverter.toProperties(this.clientConf);
        properties.setProperty(ClientProperty.AUTH_PRINCIPAL.getKey(), principal);
        properties.setProperty(ClientProperty.INSTANCE_NAME.getKey(), this.getInstanceName());
        return new ConnectorImpl(new ClientContext(new ClientInfoImpl(properties, token)));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("ZooKeeperInstance: ").append(this.getInstanceName()).append(" ").append(this.getZooKeepers());
        return sb.toString();
    }
}

