/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.io.Text;

public interface ScannerBase
extends Iterable<Map.Entry<Key, Value>>,
AutoCloseable {
    public void addScanIterator(IteratorSetting var1);

    public void removeScanIterator(String var1);

    public void updateScanIteratorOption(String var1, String var2, String var3);

    public void fetchColumnFamily(Text var1);

    default public void fetchColumnFamily(CharSequence colFam) {
        Objects.requireNonNull(colFam);
        this.fetchColumnFamily(new Text(colFam.toString()));
    }

    public void fetchColumn(Text var1, Text var2);

    default public void fetchColumn(CharSequence colFam, CharSequence colQual) {
        Objects.requireNonNull(colFam);
        Objects.requireNonNull(colQual);
        this.fetchColumn(new Text(colFam.toString()), new Text(colQual.toString()));
    }

    public void fetchColumn(IteratorSetting.Column var1);

    public void clearColumns();

    public void clearScanIterators();

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator();

    public void setTimeout(long var1, TimeUnit var3);

    public long getTimeout(TimeUnit var1);

    @Override
    public void close();

    public Authorizations getAuthorizations();

    public void setSamplerConfiguration(SamplerConfiguration var1);

    public SamplerConfiguration getSamplerConfiguration();

    public void clearSamplerConfiguration();

    public void setBatchTimeout(long var1, TimeUnit var3);

    public long getBatchTimeout(TimeUnit var1);

    public void setClassLoaderContext(String var1);

    public void clearClassLoaderContext();

    public String getClassLoaderContext();

    default public void setExecutionHints(Map<String, String> hints) {
        throw new UnsupportedOperationException();
    }
}

