/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.TabletId;

public class MutationsRejectedException
extends AccumuloException {
    private static final long serialVersionUID = 1L;
    private List<ConstraintViolationSummary> cvsl;
    private Map<TabletId, Set<SecurityErrorCode>> af;
    private Collection<String> es;
    private int unknownErrors;

    @Deprecated
    public MutationsRejectedException(Instance instance, List<ConstraintViolationSummary> cvsList, Map<TabletId, Set<SecurityErrorCode>> hashMap, Collection<String> serverSideErrors, int unknownErrors, Throwable cause) {
        super("# constraint violations : " + cvsList.size() + "  security codes: " + hashMap.toString() + "  # server errors " + serverSideErrors.size() + " # exceptions " + unknownErrors, cause);
        this.cvsl = cvsList;
        this.af = hashMap;
        this.es = serverSideErrors;
        this.unknownErrors = unknownErrors;
    }

    public MutationsRejectedException(AccumuloClient client, List<ConstraintViolationSummary> cvsList, Map<TabletId, Set<SecurityErrorCode>> hashMap, Collection<String> serverSideErrors, int unknownErrors, Throwable cause) {
        super("# constraint violations : " + cvsList.size() + "  security codes: " + MutationsRejectedException.format(hashMap, (ClientContext)client) + "  # server errors " + serverSideErrors.size() + " # exceptions " + unknownErrors, cause);
        this.cvsl = cvsList;
        this.af = hashMap;
        this.es = serverSideErrors;
        this.unknownErrors = unknownErrors;
    }

    private static String format(Map<TabletId, Set<SecurityErrorCode>> hashMap, ClientContext context) {
        HashMap result = new HashMap();
        for (Map.Entry<TabletId, Set<SecurityErrorCode>> entry : hashMap.entrySet()) {
            TabletId tabletId = entry.getKey();
            String tableInfo = Tables.getPrintableTableInfoFromId(context, TableId.of(tabletId.getTableId().toString()));
            if (!result.containsKey(tableInfo)) {
                result.put(tableInfo, new HashSet());
            }
            ((Set)result.get(tableInfo)).addAll((Collection)hashMap.get(tabletId));
        }
        return ((Object)result).toString();
    }

    public List<ConstraintViolationSummary> getConstraintViolationSummaries() {
        return this.cvsl;
    }

    public Map<TabletId, Set<SecurityErrorCode>> getSecurityErrorCodes() {
        return this.af;
    }

    public Collection<String> getErrorServers() {
        return this.es;
    }

    public int getUnknownExceptions() {
        return this.unknownErrors;
    }
}

