/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.clientImpl.ScannerOptions;
import org.apache.accumulo.core.conf.IterConfigUtil;
import org.apache.accumulo.core.conf.IterLoad;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.iterators.IteratorAdapter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.io.Text;

public class ClientSideIteratorScanner
extends ScannerOptions
implements Scanner {
    private int size;
    private Range range;
    private boolean isolated = false;
    private long readaheadThreshold = 3L;
    private SamplerConfiguration iteratorSamplerConfig;
    private ScannerTranslatorImpl smi;

    public ClientSideIteratorScanner(Scanner scanner) {
        this.smi = new ScannerTranslatorImpl(scanner, scanner.getSamplerConfiguration());
        this.range = scanner.getRange();
        this.size = scanner.getBatchSize();
        this.timeOut = scanner.getTimeout(TimeUnit.MILLISECONDS);
        this.batchTimeOut = scanner.getTimeout(TimeUnit.MILLISECONDS);
        this.readaheadThreshold = scanner.getReadaheadThreshold();
        SamplerConfiguration samplerConfig = scanner.getSamplerConfiguration();
        if (samplerConfig != null) {
            this.setSamplerConfiguration(samplerConfig);
        }
    }

    public void setSource(Scanner scanner) {
        this.smi = new ScannerTranslatorImpl(scanner, scanner.getSamplerConfiguration());
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator() {
        SortedKeyValueIterator<Key, Value> skvi;
        this.smi.scanner.setBatchSize(this.size);
        this.smi.scanner.setTimeout(this.timeOut, TimeUnit.MILLISECONDS);
        this.smi.scanner.setBatchTimeout(this.batchTimeOut, TimeUnit.MILLISECONDS);
        this.smi.scanner.setReadaheadThreshold(this.readaheadThreshold);
        if (this.isolated) {
            this.smi.scanner.enableIsolation();
        } else {
            this.smi.scanner.disableIsolation();
        }
        this.smi.samplerConfig = this.getSamplerConfiguration();
        TreeMap<Integer, IterInfo> tm = new TreeMap<Integer, IterInfo>();
        for (IterInfo iterInfo : this.serverSideIteratorList) {
            tm.put(iterInfo.getPriority(), iterInfo);
        }
        try {
            ClientSideIteratorEnvironment env = new ClientSideIteratorEnvironment(this.getSamplerConfiguration() != null, this.getIteratorSamplerConfigurationInternal());
            IterLoad iterLoad = new IterLoad().iters(tm.values()).iterOpts(this.serverSideIteratorOptions).iterEnv(env).useAccumuloClassLoader(false);
            skvi = IterConfigUtil.loadIterators(this.smi, iterLoad);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        TreeSet<ByteSequence> colfs = new TreeSet<ByteSequence>();
        for (Column c : this.getFetchedColumns()) {
            colfs.add(new ArrayByteSequence(c.getColumnFamily()));
        }
        try {
            skvi.seek(this.range, colfs, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new IteratorAdapter(skvi);
    }

    @Override
    public Authorizations getAuthorizations() {
        return this.smi.scanner.getAuthorizations();
    }

    @Override
    public void setRange(Range range) {
        this.range = range;
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    @Override
    public void setBatchSize(int size) {
        this.size = size;
    }

    @Override
    public int getBatchSize() {
        return this.size;
    }

    @Override
    public void enableIsolation() {
        this.isolated = true;
    }

    @Override
    public void disableIsolation() {
        this.isolated = false;
    }

    @Override
    public long getReadaheadThreshold() {
        return this.readaheadThreshold;
    }

    @Override
    public void setReadaheadThreshold(long batches) {
        if (batches < 0L) {
            throw new IllegalArgumentException("Number of batches before read-ahead must be non-negative");
        }
        this.readaheadThreshold = batches;
    }

    private SamplerConfiguration getIteratorSamplerConfigurationInternal() {
        SamplerConfiguration scannerSamplerConfig = this.getSamplerConfiguration();
        if (scannerSamplerConfig != null) {
            if (this.iteratorSamplerConfig != null && !this.iteratorSamplerConfig.equals(scannerSamplerConfig)) {
                throw new IllegalStateException("Scanner and iterator sampler configuration differ");
            }
            return scannerSamplerConfig;
        }
        return this.iteratorSamplerConfig;
    }

    public void setIteratorSamplerConfiguration(SamplerConfiguration sc) {
        Objects.requireNonNull(sc);
        this.iteratorSamplerConfig = sc;
    }

    public void clearIteratorSamplerConfiguration() {
        this.iteratorSamplerConfig = null;
    }

    public SamplerConfiguration getIteratorSamplerConfiguration() {
        return this.iteratorSamplerConfig;
    }

    @Override
    public void close() {
        this.smi.scanner.close();
    }

    private class ScannerTranslatorImpl
    implements SortedKeyValueIterator<Key, Value> {
        protected Scanner scanner;
        Iterator<Map.Entry<Key, Value>> iter;
        Map.Entry<Key, Value> top = null;
        private SamplerConfiguration samplerConfig;

        public ScannerTranslatorImpl(Scanner scanner, SamplerConfiguration samplerConfig) {
            this.scanner = scanner;
            this.samplerConfig = samplerConfig;
        }

        @Override
        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasTop() {
            return this.top != null;
        }

        @Override
        public void next() throws IOException {
            this.top = this.iter.hasNext() ? this.iter.next() : null;
        }

        @Override
        public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
            if (!inclusive && columnFamilies.size() > 0) {
                throw new IllegalArgumentException();
            }
            this.scanner.setRange(range);
            this.scanner.clearColumns();
            for (ByteSequence colf : columnFamilies) {
                this.scanner.fetchColumnFamily(new Text(colf.toArray()));
            }
            if (this.samplerConfig == null) {
                this.scanner.clearSamplerConfiguration();
            } else {
                this.scanner.setSamplerConfiguration(this.samplerConfig);
            }
            this.iter = this.scanner.iterator();
            this.next();
        }

        @Override
        public Key getTopKey() {
            return this.top.getKey();
        }

        @Override
        public Value getTopValue() {
            return this.top.getValue();
        }

        @Override
        public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
            return new ScannerTranslatorImpl(this.scanner, env.isSamplingEnabled() ? env.getSamplerConfiguration() : null);
        }
    }

    private class ClientSideIteratorEnvironment
    implements IteratorEnvironment {
        private SamplerConfiguration samplerConfig;
        private boolean sampleEnabled;

        ClientSideIteratorEnvironment(boolean sampleEnabled, SamplerConfiguration samplerConfig) {
            this.sampleEnabled = sampleEnabled;
            this.samplerConfig = samplerConfig;
        }

        @Override
        public IteratorUtil.IteratorScope getIteratorScope() {
            return IteratorUtil.IteratorScope.scan;
        }

        @Override
        public boolean isFullMajorCompaction() {
            return false;
        }

        @Override
        public boolean isUserCompaction() {
            return false;
        }

        @Override
        public Authorizations getAuthorizations() {
            return ClientSideIteratorScanner.this.getAuthorizations();
        }

        @Override
        public IteratorEnvironment cloneWithSamplingEnabled() {
            return new ClientSideIteratorEnvironment(true, this.samplerConfig);
        }

        @Override
        public boolean isSamplingEnabled() {
            return this.sampleEnabled;
        }

        @Override
        public SamplerConfiguration getSamplerConfiguration() {
            return this.samplerConfig;
        }
    }
}

