/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.IParameterSplitter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigOpts
extends Help {
    private static final Logger log = LoggerFactory.getLogger(ConfigOpts.class);
    @Parameter(names={"-p", "-props", "--props"}, description="Sets path to accumulo.properties.The classpath will be searched if this property is not set")
    private String propsPath;
    @Parameter(names={"-o"}, splitter=NullSplitter.class, description="Overrides configuration set in accumulo.properties (but NOT system-wide config set in Zookeeper). Expected format: -o <key>=<value>")
    private List<String> overrides = new ArrayList<String>();
    private SiteConfiguration siteConfig = null;

    public synchronized String getPropertiesPath() {
        if (this.propsPath == null) {
            this.propsPath = SiteConfiguration.getAccumuloPropsLocation().getFile();
        }
        return this.propsPath;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="process runs in same security context as admin who provided path")
    public synchronized SiteConfiguration getSiteConfiguration() {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfiguration(new File(this.getPropertiesPath()), this.getOverrides());
        }
        return this.siteConfig;
    }

    public Map<String, String> getOverrides() {
        return ConfigOpts.getOverrides(this.overrides);
    }

    public static Map<String, String> getOverrides(List<String> args) {
        HashMap<String, String> config = new HashMap<String, String>();
        for (String prop : args) {
            String[] propArgs = prop.split("=", 2);
            if (propArgs.length == 2) {
                String key = propArgs[0].trim();
                String value = propArgs[1].trim();
                if (key.isEmpty() || value.isEmpty()) {
                    throw new IllegalArgumentException("Invalid command line -o option: " + prop);
                }
                config.put(key, value);
                continue;
            }
            throw new IllegalArgumentException("Invalid command line -o option: " + prop);
        }
        return config;
    }

    @Override
    public void parseArgs(String programName, String[] args, Object ... others) {
        super.parseArgs(programName, args, others);
        if (this.getOverrides().size() > 0) {
            log.info("The following configuration was set on the command line:");
            for (Map.Entry<String, String> entry : this.getOverrides().entrySet()) {
                String key = entry.getKey();
                log.info(key + " = " + (Property.isSensitive(key) ? "<hidden>" : entry.getValue()));
            }
        }
    }

    public static class NullSplitter
    implements IParameterSplitter {
        public List<String> split(String value) {
            return Collections.singletonList(value);
        }
    }
}

