/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.cli;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.IParameterSplitter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.accumulo.core.cli.ConfigOpts;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientInfoImpl;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.htrace.NullScope;
import org.apache.htrace.Sampler;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;

public class ClientOpts
extends Help {
    private String legacyClientOpts = "-p -tc --tokenClass -i --instance --site-file --keytab --debug -fake --mock --ssl --sasl";
    @Parameter(names={"-p", "-tc", "--tokenClass", "-i", "--instance", "--site-file", "--keytab"}, hidden=true)
    private String legacyOpts = null;
    @Parameter(names={"--debug", "-fake", "--mock", "--ssl", "--sasl"}, hidden=true)
    private boolean legacyOptsBoolean = false;
    @Parameter(names={"-u", "--user"}, description="Connection user")
    public String principal = null;
    @Parameter(names={"--password"}, converter=PasswordConverter.class, description="Enter the connection password", password=true)
    private Password securePassword = null;
    @Parameter(names={"-auths", "--auths"}, converter=AuthConverter.class, description="the authorizations to use when reading or writing")
    public Authorizations auths = Authorizations.EMPTY;
    @Parameter(names={"-c", "--config-file"}, description="Read the given client config file. If omitted, the classpath will be searched for file named accumulo-client.properties")
    private String clientConfigFile = null;
    @Parameter(names={"-o"}, splitter=NullSplitter.class, description="Overrides property in accumulo-client.properties. Expected format: -o <key>=<value>")
    private List<String> overrides = new ArrayList<String>();
    @Parameter(names={"--trace"}, description="turn on distributed tracing")
    public boolean trace = false;
    private Properties cachedProps = null;

    public AuthenticationToken getToken() {
        return ClientProperty.getAuthenticationToken(this.getClientProps());
    }

    public Map<String, String> getOverrides() {
        return ConfigOpts.getOverrides(this.overrides);
    }

    public TraceScope parseArgsAndTrace(String programName, String[] args, Object ... others) {
        this.parseArgs(programName, args, others);
        return this.trace ? Trace.startSpan((String)programName, (Sampler)Sampler.ALWAYS) : NullScope.INSTANCE;
    }

    @Override
    public void parseArgs(String programName, String[] args, Object ... others) {
        super.parseArgs(programName, args, others);
        if (this.legacyOpts != null || this.legacyOptsBoolean) {
            StringBuilder badOptions = new StringBuilder();
            for (String arg : args) {
                if (!this.legacyClientOpts.contains(arg)) continue;
                badOptions.append(arg).append(" ");
            }
            throw new IllegalArgumentException("The Client options: " + badOptions.toString() + "have been dropped. Use accumulo-client.properties for any connection or token options. See '-c, --config-file' option.");
        }
    }

    public String getClientConfigFile() {
        URL clientPropsUrl;
        if (this.clientConfigFile == null && (clientPropsUrl = ClientOpts.class.getClassLoader().getResource("accumulo-client.properties")) != null) {
            this.clientConfigFile = clientPropsUrl.getFile();
        }
        return this.clientConfigFile;
    }

    public Properties getClientProps() {
        if (this.cachedProps == null) {
            this.cachedProps = new Properties();
            if (this.getClientConfigFile() != null) {
                this.cachedProps = ClientInfoImpl.toProperties(this.getClientConfigFile());
            }
            if (this.principal != null) {
                this.cachedProps.setProperty(ClientProperty.AUTH_PRINCIPAL.getKey(), this.principal);
            }
            if (this.securePassword != null) {
                ClientProperty.setPassword(this.cachedProps, this.securePassword.toString());
            }
            this.getOverrides().forEach((k, v) -> this.cachedProps.put(k, v));
            ClientProperty.validate(this.cachedProps);
        }
        return this.cachedProps;
    }

    public static class NullSplitter
    implements IParameterSplitter {
        public List<String> split(String value) {
            return Collections.singletonList(value);
        }
    }

    public static class VisibilityConverter
    implements IStringConverter<ColumnVisibility> {
        public ColumnVisibility convert(String value) {
            return new ColumnVisibility(value);
        }
    }

    public static class PasswordConverter
    implements IStringConverter<Password> {
        public Password convert(String value) {
            return new Password(value);
        }
    }

    public static class Password {
        public byte[] value;

        public Password(String dfault) {
            this.value = dfault.getBytes(StandardCharsets.UTF_8);
        }

        public String toString() {
            return new String(this.value, StandardCharsets.UTF_8);
        }
    }

    public static class AuthConverter
    implements IStringConverter<Authorizations> {
        public Authorizations convert(String value) {
            return new Authorizations(value.split(","));
        }
    }
}

