/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.zookeeper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionWatcher {
    private static final Logger log = LoggerFactory.getLogger(TransactionWatcher.class);
    private final Map<Long, AtomicInteger> counts = new HashMap<Long, AtomicInteger>();
    private final Arbitrator arbitrator;

    public TransactionWatcher(Arbitrator arbitrator) {
        this.arbitrator = arbitrator;
    }

    public TransactionWatcher(ServerContext context) {
        this(new ZooArbitrator(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runQuietly(String ztxBulk, long tid, Runnable task) {
        Map<Long, AtomicInteger> map = this.counts;
        synchronized (map) {
            try {
                if (!this.arbitrator.transactionAlive(ztxBulk, tid)) {
                    log.debug("Transaction " + tid + " of type " + ztxBulk + " is no longer active.");
                    return;
                }
            }
            catch (Exception e) {
                log.warn("Unable to check if transaction " + tid + " of type " + ztxBulk + " is alive ", (Throwable)e);
                return;
            }
            this.increment(tid);
        }
        try {
            task.run();
        }
        finally {
            this.decrement(tid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(String ztxBulk, long tid, Callable<T> callable) throws Exception {
        Map<Long, AtomicInteger> map = this.counts;
        synchronized (map) {
            if (!this.arbitrator.transactionAlive(ztxBulk, tid)) {
                throw new Exception("Transaction " + tid + " of type " + ztxBulk + " is no longer active");
            }
            this.increment(tid);
        }
        try {
            map = callable.call();
            return (T)map;
        }
        finally {
            this.decrement(tid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive(long tid) {
        Map<Long, AtomicInteger> map = this.counts;
        synchronized (map) {
            log.debug("Transactions in progress {}", this.counts);
            AtomicInteger count = this.counts.get(tid);
            return count != null && count.get() > 0;
        }
    }

    private void increment(long tid) {
        AtomicInteger count = this.counts.get(tid);
        if (count == null) {
            count = new AtomicInteger();
            this.counts.put(tid, count);
        }
        count.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrement(long tid) {
        Map<Long, AtomicInteger> map = this.counts;
        synchronized (map) {
            AtomicInteger count = this.counts.get(tid);
            if (count == null) {
                log.error("unexpected missing count for transaction {}", (Object)tid);
            } else if (count.decrementAndGet() == 0) {
                this.counts.remove(tid);
            }
        }
    }

    public static class ZooArbitrator
    implements Arbitrator {
        private ServerContext context;
        private ZooReader rdr;

        public ZooArbitrator(ServerContext context) {
            this.context = context;
            this.rdr = new ZooReader(context.getZooKeepers(), context.getZooKeepersSessionTimeOut());
        }

        @Override
        public boolean transactionAlive(String type, long tid) throws Exception {
            String path = this.context.getZooKeeperRoot() + "/" + type + "/" + tid;
            this.rdr.sync(path);
            return this.rdr.exists(path);
        }

        public static void start(ServerContext context, String type, long tid) throws KeeperException, InterruptedException {
            ZooReaderWriter writer = context.getZooReaderWriter();
            writer.putPersistentData(context.getZooKeeperRoot() + "/" + type, new byte[0], ZooUtil.NodeExistsPolicy.OVERWRITE);
            writer.putPersistentData(context.getZooKeeperRoot() + "/" + type + "/" + tid, new byte[0], ZooUtil.NodeExistsPolicy.OVERWRITE);
            writer.putPersistentData(context.getZooKeeperRoot() + "/" + type + "/" + tid + "-running", new byte[0], ZooUtil.NodeExistsPolicy.OVERWRITE);
        }

        public static void stop(ServerContext context, String type, long tid) throws KeeperException, InterruptedException {
            ZooReaderWriter writer = context.getZooReaderWriter();
            writer.recursiveDelete(context.getZooKeeperRoot() + "/" + type + "/" + tid, ZooUtil.NodeMissingPolicy.SKIP);
        }

        public static void cleanup(ServerContext context, String type, long tid) throws KeeperException, InterruptedException {
            ZooReaderWriter writer = context.getZooReaderWriter();
            writer.recursiveDelete(context.getZooKeeperRoot() + "/" + type + "/" + tid, ZooUtil.NodeMissingPolicy.SKIP);
            writer.recursiveDelete(context.getZooKeeperRoot() + "/" + type + "/" + tid + "-running", ZooUtil.NodeMissingPolicy.SKIP);
        }

        public static Set<Long> allTransactionsAlive(ServerContext context, String type) throws KeeperException, InterruptedException {
            ZooReaderWriter reader = context.getZooReaderWriter();
            HashSet<Long> result = new HashSet<Long>();
            String parent = context.getZooKeeperRoot() + "/" + type;
            reader.sync(parent);
            List children = reader.getChildren(parent);
            for (String child : children) {
                if (child.endsWith("-running")) continue;
                result.add(Long.parseLong(child));
            }
            return result;
        }

        @Override
        public boolean transactionComplete(String type, long tid) throws Exception {
            String path = this.context.getZooKeeperRoot() + "/" + type + "/" + tid + "-running";
            this.rdr.sync(path);
            return !this.rdr.exists(path);
        }
    }

    public static interface Arbitrator {
        public boolean transactionAlive(String var1, long var2) throws Exception;

        public boolean transactionComplete(String var1, long var2) throws Exception;
    }
}

