/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.state;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.master.state.DistributedStore;
import org.apache.accumulo.server.master.state.DistributedStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooStore
implements DistributedStore {
    private static final Logger log = LoggerFactory.getLogger(ZooStore.class);
    private ServerContext context;
    private String basePath;
    private ZooCache cache;

    public ZooStore(ServerContext context) {
        this.context = context;
        this.cache = new ZooCache((ZooReader)context.getZooReaderWriter(), null);
        String zkRoot = context.getZooKeeperRoot();
        if (zkRoot.endsWith("/")) {
            zkRoot = zkRoot.substring(0, zkRoot.length() - 1);
        }
        this.basePath = zkRoot;
    }

    @Override
    public byte[] get(String path) throws DistributedStoreException {
        try {
            return this.cache.get(this.relative(path));
        }
        catch (Exception ex) {
            throw new DistributedStoreException(ex);
        }
    }

    private String relative(String path) {
        return this.basePath + path;
    }

    @Override
    public List<String> getChildren(String path) throws DistributedStoreException {
        try {
            return this.cache.getChildren(this.relative(path));
        }
        catch (Exception ex) {
            throw new DistributedStoreException(ex);
        }
    }

    @Override
    public void put(String path, byte[] bs) throws DistributedStoreException {
        try {
            path = this.relative(path);
            this.context.getZooReaderWriter().putPersistentData(path, bs, ZooUtil.NodeExistsPolicy.OVERWRITE);
            this.cache.clear();
            log.debug("Wrote {} to {}", (Object)new String(bs, StandardCharsets.UTF_8), (Object)path);
        }
        catch (Exception ex) {
            throw new DistributedStoreException(ex);
        }
    }

    @Override
    public void remove(String path) throws DistributedStoreException {
        try {
            log.debug("Removing {}", (Object)path);
            path = this.relative(path);
            ZooReaderWriter zoo = this.context.getZooReaderWriter();
            if (zoo.exists(path)) {
                zoo.recursiveDelete(path, ZooUtil.NodeMissingPolicy.SKIP);
            }
            this.cache.clear();
        }
        catch (Exception ex) {
            throw new DistributedStoreException(ex);
        }
    }
}

